/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.system.microcontainer.ServiceControllerContext;
/*     */ 
/*     */ public class ServiceInjectionValueMetaData extends AbstractMetaDataVisitorNode
/*     */   implements ServiceValueMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private transient Object dependency;
/*     */   private String property;
/*  52 */   private ControllerState dependentState = ControllerState.INSTALLED;
/*     */ 
/*     */   public ServiceInjectionValueMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceInjectionValueMetaData(Object dependency)
/*     */   {
/*  68 */     this(dependency, null);
/*     */   }
/*     */ 
/*     */   public ServiceInjectionValueMetaData(Object dependency, String property)
/*     */   {
/*  79 */     this(dependency, property, ControllerState.INSTALLED);
/*     */   }
/*     */ 
/*     */   public ServiceInjectionValueMetaData(Object dependency, String property, ControllerState dependentState)
/*     */   {
/*  91 */     setDependency(dependency);
/*  92 */     setProperty(property);
/*  93 */     setDependentState(dependentState);
/*     */   }
/*     */ 
/*     */   public Object getDependency()
/*     */   {
/* 103 */     return this.dependency;
/*     */   }
/*     */ 
/*     */   public void setDependency(Object dependency)
/*     */   {
/* 113 */     if (dependency == null)
/* 114 */       throw new IllegalArgumentException("Null dependency");
/* 115 */     this.dependency = dependency;
/*     */   }
/*     */ 
/*     */   public String getProperty()
/*     */   {
/* 125 */     return this.property;
/*     */   }
/*     */ 
/*     */   public void setProperty(String property)
/*     */   {
/* 135 */     this.property = property;
/*     */   }
/*     */ 
/*     */   public ControllerState getDependentState()
/*     */   {
/* 145 */     return this.dependentState;
/*     */   }
/*     */ 
/*     */   public void setDependentState(ControllerState dependentState)
/*     */   {
/* 155 */     this.dependentState = dependentState;
/*     */   }
/*     */ 
/*     */   public Object getValue(ServiceValueContext valueContext) throws Throwable
/*     */   {
/* 160 */     KernelController controller = valueContext.getController();
/*     */ 
/* 162 */     ControllerState state = this.dependentState;
/* 163 */     if (state == null) {
/* 164 */       state = ControllerState.INSTALLED;
/*     */     }
/* 166 */     ControllerContext context = controller.getContext(this.dependency, state);
/* 167 */     if (context == null)
/* 168 */       throw new Error("Should not be here - dependency failed! " + this);
/* 169 */     Object result = context.getTarget();
/* 170 */     if (this.property != null)
/*     */     {
/* 172 */       if ((context instanceof AttributeDispatchContext))
/*     */       {
/* 174 */         AttributeDispatchContext adc = (AttributeDispatchContext)context;
/* 175 */         result = adc.get(this.property);
/*     */       }
/*     */       else {
/* 178 */         throw new IllegalArgumentException("Cannot use property attribute, context is not AttributeDispatchContext: " + context + ", metadata: " + this);
/*     */       }
/*     */     }
/*     */ 
/* 182 */     return result;
/*     */   }
/*     */ 
/*     */   public void visit(ServiceMetaDataVisitor visitor)
/*     */   {
/* 187 */     ServiceControllerContext context = visitor.getControllerContext();
/* 188 */     Object name = context.getName();
/* 189 */     ControllerState whenRequired = visitor.getContextState();
/*     */ 
/* 191 */     DependencyItem item = new AbstractDependencyItem(name, this.dependency, whenRequired, this.dependentState);
/* 192 */     visitor.addDependency(item);
/*     */ 
/* 194 */     visitor.visit(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceInjectionValueMetaData
 * JD-Core Version:    0.6.0
 */