/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.io.Serializable;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ServiceElementValueMetaData extends AbstractMetaDataVisitorNode
/*     */   implements ServiceValueMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  51 */   private static final Logger log = Logger.getLogger(ServiceElementValueMetaData.class);
/*     */   private Element element;
/*     */ 
/*     */   public ServiceElementValueMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceElementValueMetaData(Element element)
/*     */   {
/*  70 */     setElement(element);
/*     */   }
/*     */ 
/*     */   public Element getElement()
/*     */   {
/*  80 */     return this.element;
/*     */   }
/*     */ 
/*     */   public void setElement(Element element)
/*     */   {
/*  90 */     if (element == null)
/*  91 */       throw new IllegalArgumentException("Null element");
/*  92 */     this.element = element;
/*     */   }
/*     */ 
/*     */   public Object getValue(ServiceValueContext valueContext)
/*     */     throws Exception
/*     */   {
/*  98 */     if (valueContext.isReplace())
/*     */     {
/* 100 */       PropertyEditor editor = PropertyEditorManager.findEditor(Element.class);
/* 101 */       if (editor == null) {
/* 102 */         log.warn("Cannot perform property replace on Element");
/*     */       }
/*     */       else {
/* 105 */         editor.setValue(this.element);
/* 106 */         String text = editor.getAsText();
/* 107 */         text = StringPropertyReplacer.replaceProperties(text);
/* 108 */         editor.setAsText(text);
/* 109 */         return editor.getValue();
/*     */       }
/*     */     }
/*     */ 
/* 113 */     return this.element;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceElementValueMetaData
 * JD-Core Version:    0.6.0
 */