/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class ServiceDeploymentParser
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(ServiceDeploymentParser.class);
/*     */   private Document document;
/*     */ 
/*     */   public ServiceDeploymentParser(Document document)
/*     */   {
/*  57 */     if (document == null) {
/*  58 */       throw new IllegalArgumentException("Null document");
/*     */     }
/*  60 */     this.document = document;
/*     */   }
/*     */ 
/*     */   public ServiceDeployment parse()
/*     */     throws DeploymentException
/*     */   {
/*  71 */     ServiceDeployment parsed = new ServiceDeployment();
/*     */ 
/*  73 */     List classPaths = parseXMLClasspath(this.document);
/*  74 */     parsed.setClassPaths(classPaths);
/*     */ 
/*  76 */     LoaderRepositoryFactory.LoaderRepositoryConfig repository = parseLoaderRepositoryConfig(this.document);
/*  77 */     if (repository != null) {
/*  78 */       parsed.setLoaderRepositoryConfig(repository);
/*     */     }
/*     */ 
/*  81 */     parsed.setConfig(this.document.getDocumentElement());
/*  82 */     return parsed;
/*     */   }
/*     */ 
/*     */   private List<ServiceDeploymentClassPath> parseXMLClasspath(Document document)
/*     */     throws DeploymentException
/*     */   {
/*  94 */     ArrayList classPaths = null;
/*     */ 
/*  96 */     NodeList children = document.getDocumentElement().getChildNodes();
/*  97 */     for (int i = 0; i < children.getLength(); i++)
/*     */     {
/*  99 */       if (children.item(i).getNodeType() != 1)
/*     */         continue;
/* 101 */       Element classpathElement = (Element)children.item(i);
/* 102 */       if (!classpathElement.getTagName().equals("classpath"))
/*     */         continue;
/* 104 */       log.debug("Found classpath element: " + classpathElement);
/* 105 */       if (!classpathElement.hasAttribute("codebase")) {
/* 106 */         throw new DeploymentException("Invalid classpath element missing codebase: " + classpathElement);
/*     */       }
/* 108 */       String codebase = classpathElement.getAttribute("codebase").trim();
/* 109 */       codebase = StringPropertyReplacer.replaceProperties(codebase);
/*     */ 
/* 111 */       String archives = null;
/* 112 */       if (classpathElement.hasAttribute("archives"))
/*     */       {
/* 114 */         archives = classpathElement.getAttribute("archives").trim();
/* 115 */         archives = StringPropertyReplacer.replaceProperties(archives);
/* 116 */         if ("".equals(archives)) {
/* 117 */           archives = null;
/*     */         }
/*     */       }
/* 120 */       if (classPaths == null) {
/* 121 */         classPaths = new ArrayList();
/*     */       }
/* 123 */       ServiceDeploymentClassPath classPath = new ServiceDeploymentClassPath(codebase, archives);
/* 124 */       classPaths.add(classPath);
/*     */     }
/*     */ 
/* 128 */     return classPaths;
/*     */   }
/*     */ 
/*     */   private LoaderRepositoryFactory.LoaderRepositoryConfig parseLoaderRepositoryConfig(Document document)
/*     */     throws DeploymentException
/*     */   {
/* 141 */     NodeList loaders = document.getElementsByTagName("loader-repository");
/* 142 */     if (loaders.getLength() > 0)
/*     */     {
/* 144 */       Element loader = (Element)loaders.item(0);
/*     */       try
/*     */       {
/* 147 */         return LoaderRepositoryFactory.parseRepositoryConfig(loader);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 151 */         throw DeploymentException.rethrowAsDeploymentException("Unable to parse loader repository config", e);
/*     */       }
/*     */     }
/* 154 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceDeploymentParser
 * JD-Core Version:    0.6.0
 */