/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.system.microcontainer.LifecycleDependencyItem;
/*     */ import org.jboss.system.microcontainer.ServiceControllerContext;
/*     */ 
/*     */ public class ServiceDependencyValueMetaData extends AbstractMetaDataVisitorNode
/*     */   implements ServiceValueMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String dependency;
/*     */   private ObjectName objectName;
/*     */   private String proxyType;
/*     */ 
/*     */   public ServiceDependencyValueMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceDependencyValueMetaData(String dependency)
/*     */   {
/*  78 */     setDependency(dependency);
/*     */   }
/*     */ 
/*     */   public ServiceDependencyValueMetaData(String dependency, String proxyType)
/*     */   {
/*  89 */     setDependency(dependency);
/*  90 */     setProxyType(proxyType);
/*     */   }
/*     */ 
/*     */   public String getDependency()
/*     */   {
/* 100 */     if (this.dependency == null)
/* 101 */       return this.objectName.getCanonicalName();
/* 102 */     return this.dependency;
/*     */   }
/*     */ 
/*     */   public void setDependency(String dependency)
/*     */   {
/* 112 */     if (dependency == null)
/* 113 */       throw new IllegalArgumentException("Null dependency");
/* 114 */     this.dependency = dependency;
/* 115 */     this.objectName = null;
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */     throws MalformedObjectNameException
/*     */   {
/* 126 */     if (this.objectName == null)
/*     */     {
/* 128 */       if ((this.dependency == null) || (this.dependency.trim().length() == 0))
/* 129 */         throw new MalformedObjectNameException("Missing object name in depends");
/* 130 */       ObjectName name = new ObjectName(this.dependency);
/* 131 */       if (name.isPattern())
/* 132 */         throw new MalformedObjectNameException("ObjectName patterns are not allowed in depends: " + this.objectName);
/* 133 */       this.objectName = new ObjectName(this.dependency);
/* 134 */       this.dependency = null;
/*     */     }
/* 136 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public void setObjectName(ObjectName objectName)
/*     */   {
/* 146 */     if (objectName == null)
/* 147 */       throw new IllegalArgumentException("Null objectName");
/* 148 */     this.objectName = objectName;
/*     */   }
/*     */ 
/*     */   public String getProxyType()
/*     */   {
/* 158 */     return this.proxyType;
/*     */   }
/*     */ 
/*     */   public void setProxyType(String proxyType)
/*     */   {
/* 168 */     this.proxyType = proxyType;
/*     */   }
/*     */ 
/*     */   public Object getValue(ServiceValueContext valueContext) throws Exception
/*     */   {
/* 173 */     MBeanAttributeInfo attributeInfo = valueContext.getAttributeInfo();
/* 174 */     ClassLoader cl = valueContext.getClassloader();
/* 175 */     MBeanServer server = valueContext.getServer();
/*     */ 
/* 177 */     ObjectName objectName = getObjectName();
/*     */ 
/* 179 */     if (this.proxyType != null)
/*     */     {
/* 181 */       if (this.proxyType.equals("attribute"))
/*     */       {
/* 183 */         this.proxyType = attributeInfo.getType();
/* 184 */         if (this.proxyType == null) {
/* 185 */           throw new DeploymentException("AttributeInfo for " + attributeInfo.getName() + " has no type");
/*     */         }
/*     */       }
/* 188 */       Class proxyClass = cl.loadClass(this.proxyType);
/* 189 */       return MBeanProxyExt.create(proxyClass, objectName, server, true);
/*     */     }
/*     */ 
/* 192 */     return objectName;
/*     */   }
/*     */ 
/*     */   public void visit(ServiceMetaDataVisitor visitor)
/*     */   {
/* 197 */     ServiceControllerContext context = visitor.getControllerContext();
/* 198 */     Object name = context.getName();
/* 199 */     Object other = this.dependency;
/*     */     try
/*     */     {
/* 202 */       other = getObjectName().getCanonicalName();
/*     */     }
/*     */     catch (MalformedObjectNameException ignored)
/*     */     {
/*     */     }
/*     */ 
/* 208 */     visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.CREATE));
/* 209 */     visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.START));
/* 210 */     visitor.visit(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceDependencyValueMetaData
 * JD-Core Version:    0.6.0
 */