/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.system.microcontainer.LifecycleDependencyItem;
/*     */ import org.jboss.system.microcontainer.ServiceControllerContext;
/*     */ 
/*     */ public class ServiceDependencyListValueMetaData extends AbstractMetaDataVisitorNode
/*     */   implements ServiceValueMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private List<String> dependencies;
/*     */   private List<ObjectName> objectNames;
/*     */ 
/*     */   public ServiceDependencyListValueMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceDependencyListValueMetaData(List<String> dependencies)
/*     */   {
/*  66 */     setDependencies(dependencies);
/*     */   }
/*     */ 
/*     */   public List<String> getDependencies()
/*     */   {
/*  76 */     if (this.dependencies == null)
/*     */     {
/*  78 */       List result = new ArrayList(this.objectNames.size());
/*  79 */       for (ObjectName objectName : this.objectNames)
/*  80 */         result.add(objectName.getCanonicalName());
/*  81 */       return result;
/*     */     }
/*  83 */     return this.dependencies;
/*     */   }
/*     */ 
/*     */   public void setDependencies(List<String> dependencies)
/*     */   {
/*  93 */     if (dependencies == null)
/*  94 */       throw new IllegalArgumentException("Null dependencies");
/*  95 */     for (String dependency : dependencies)
/*     */     {
/*  97 */       if (dependency == null) {
/*  98 */         throw new IllegalArgumentException("Null dependency in dependencies");
/*     */       }
/*     */     }
/* 101 */     this.dependencies = dependencies;
/* 102 */     this.objectNames = null;
/*     */   }
/*     */ 
/*     */   public List<ObjectName> getObjectNames()
/*     */     throws MalformedObjectNameException
/*     */   {
/* 113 */     if (this.objectNames == null)
/*     */     {
/* 115 */       List names = new ArrayList(this.dependencies.size());
/* 116 */       for (String dependency : this.dependencies)
/*     */       {
/* 118 */         if (dependency.trim().length() == 0)
/* 119 */           throw new MalformedObjectNameException("Missing object name in depends-list");
/* 120 */         ObjectName objectName = new ObjectName(dependency);
/* 121 */         if (objectName.isPattern())
/* 122 */           throw new MalformedObjectNameException("ObjectName patterns are not allowed in depends-list: " + dependency);
/* 123 */         names.add(objectName);
/*     */       }
/* 125 */       this.objectNames = names;
/* 126 */       this.dependencies = null;
/*     */     }
/* 128 */     return this.objectNames;
/*     */   }
/*     */ 
/*     */   public void setObjectNames(List<ObjectName> objectNames)
/*     */   {
/* 138 */     if (objectNames == null)
/* 139 */       throw new IllegalArgumentException("Null objectNames");
/* 140 */     for (ObjectName objectName : objectNames)
/*     */     {
/* 142 */       if (objectName == null) {
/* 143 */         throw new IllegalArgumentException("Null object name in objectNames");
/*     */       }
/*     */     }
/* 146 */     this.objectNames = objectNames;
/*     */   }
/*     */ 
/*     */   public Object getValue(ServiceValueContext valueContext) throws Exception
/*     */   {
/* 151 */     return getObjectNames();
/*     */   }
/*     */ 
/*     */   public void visit(ServiceMetaDataVisitor visitor)
/*     */   {
/* 156 */     ServiceControllerContext context = visitor.getControllerContext();
/* 157 */     Object name = context.getName();
/* 158 */     List list = this.dependencies;
/*     */     try
/*     */     {
/* 161 */       List names = getObjectNames();
/* 162 */       list = new ArrayList(names.size());
/* 163 */       for (ObjectName objectName : names)
/* 164 */         list.add(objectName.getCanonicalName());
/*     */     }
/*     */     catch (MalformedObjectNameException ignored)
/*     */     {
/*     */     }
/* 169 */     for (String other : list)
/*     */     {
/* 172 */       visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.CREATE));
/* 173 */       visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.START));
/*     */     }
/* 175 */     visitor.visit(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceDependencyListValueMetaData
 * JD-Core Version:    0.6.0
 */