/*     */ package org.jboss.system.metadata;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import org.jboss.system.ConfigurationException;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ 
/*     */ public class ServiceConstructorMetaData
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  49 */   public static final Object[] EMPTY_PARAMETERS = new Object[0];
/*     */ 
/*  52 */   public static final String[] EMPTY_PARAMS = new String[0];
/*     */ 
/*  55 */   public static final String[] EMPTY_SIGNATURE = new String[0];
/*     */ 
/*  58 */   private String[] signature = EMPTY_SIGNATURE;
/*     */ 
/*  61 */   private String[] params = EMPTY_PARAMS;
/*     */   private Object[] parameters;
/*     */ 
/*     */   public String[] getParams()
/*     */   {
/*  73 */     return this.params;
/*     */   }
/*     */ 
/*     */   public void setParams(String[] params)
/*     */   {
/*  83 */     if (params == null)
/*  84 */       throw new IllegalArgumentException("Null params");
/*  85 */     this.params = params;
/*     */   }
/*     */ 
/*     */   public String[] getSignature()
/*     */     throws ConfigurationException
/*     */   {
/*  96 */     for (String string : this.signature)
/*     */     {
/*  98 */       if ((string == null) || (string.trim().length() == 0))
/*  99 */         throw new ConfigurationException("Missing or empty 'type' attribute in constructor arg");
/*     */     }
/* 101 */     return this.signature;
/*     */   }
/*     */ 
/*     */   public void setSignature(String[] signature)
/*     */   {
/* 111 */     if (signature == null)
/* 112 */       throw new IllegalArgumentException("Null signature");
/* 113 */     this.signature = signature;
/*     */   }
/*     */ 
/*     */   public Object[] getParameters(ClassLoader cl)
/*     */     throws Exception
/*     */   {
/* 125 */     if (this.parameters != null) {
/* 126 */       return this.parameters;
/*     */     }
/* 128 */     if (this.params.length == 0) {
/* 129 */       return EMPTY_PARAMETERS;
/*     */     }
/* 131 */     String[] signature = getSignature();
/*     */ 
/* 133 */     Object[] result = new Object[this.params.length];
/* 134 */     for (int i = 0; i < result.length; i++)
/*     */     {
/* 136 */       if (this.params[i] == null) {
/* 137 */         throw new ConfigurationException("Missing 'value' attribute in constructor arg");
/*     */       }
/* 139 */       String value = StringPropertyReplacer.replaceProperties(this.params[i]);
/* 140 */       Object realValue = value;
/*     */ 
/* 142 */       if (signature[i] != null)
/*     */       {
/* 145 */         Class typeClass = Classes.getPrimitiveTypeForName(signature[i]);
/* 146 */         if (typeClass == null) {
/* 147 */           typeClass = cl.loadClass(signature[i]);
/*     */         }
/*     */ 
/* 150 */         PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
/* 151 */         if (editor == null)
/*     */         {
/*     */           try
/*     */           {
/* 156 */             Class[] sig = { String.class };
/* 157 */             Constructor ctor = typeClass.getConstructor(sig);
/* 158 */             Object[] args = { value };
/* 159 */             realValue = ctor.newInstance(args);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 163 */             throw new ConfigurationException("No property editor for type: " + typeClass);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 168 */           editor.setAsText(value);
/* 169 */           realValue = editor.getValue();
/*     */         }
/*     */       }
/* 172 */       result[i] = realValue;
/*     */     }
/* 174 */     return result;
/*     */   }
/*     */ 
/*     */   public void setParameters(Object[] parameters)
/*     */   {
/* 184 */     this.parameters = parameters;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.metadata.ServiceConstructorMetaData
 * JD-Core Version:    0.6.0
 */