/*     */ package org.jboss.system.filterfactory;
/*     */ 
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.relation.MBeanServerNotificationFilter;
/*     */ import org.jboss.system.NotificationFilterFactory;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class MBeanServerNotificationFilterFactory
/*     */   implements NotificationFilterFactory
/*     */ {
/*     */   public static final String ENABLE_ELEMENT = "enable";
/*     */   public static final String ENABLE_TYPE_ATTRIBUTE = "type";
/*     */   public static final String ENABLE_OBJECTNAME_ATTRIBUTE = "object-name";
/*     */ 
/*     */   public NotificationFilter createNotificationFilter(Element filterConfig)
/*     */     throws Exception
/*     */   {
/*  88 */     MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
/*     */ 
/*  92 */     NodeList filterChildren = filterConfig.getChildNodes();
/*     */ 
/*  94 */     for (int i = 0; i < filterChildren.getLength(); i++)
/*     */     {
/*  96 */       Node filterChildNode = filterChildren.item(i);
/*     */ 
/*  99 */       if (!filterChildNode.getNodeName().equals("enable")) {
/*     */         continue;
/*     */       }
/* 102 */       if (((Element)filterChildNode).hasAttribute("type"))
/*     */       {
/* 104 */         String type = ((Element)filterChildNode).getAttribute("type");
/*     */ 
/* 106 */         filter.enableType(type);
/*     */       }
/* 108 */       else if (((Element)filterChildNode).hasAttribute("object-name"))
/*     */       {
/* 110 */         String objectName = ((Element)filterChildNode).getAttribute("object-name");
/*     */ 
/* 113 */         filter.enableObjectName(new ObjectName(objectName));
/*     */       }
/*     */       else
/*     */       {
/* 117 */         throw new Exception("'enable' element must have a 'type' or a 'object-name' attribute");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 123 */     return filter;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.filterfactory.MBeanServerNotificationFilterFactory
 * JD-Core Version:    0.6.0
 */