/*     */ package org.jboss.system.filterfactory;
/*     */ 
/*     */ import javax.management.AttributeChangeNotificationFilter;
/*     */ import javax.management.NotificationFilter;
/*     */ import org.jboss.system.NotificationFilterFactory;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class AttributeChangeNotificationFilterFactory
/*     */   implements NotificationFilterFactory
/*     */ {
/*     */   public static final String ENABLE_ELEMENT = "enable";
/*     */   public static final String ENABLE_ATTRNAME_ATTRIBUTE = "attribute-name";
/*     */ 
/*     */   public NotificationFilter createNotificationFilter(Element filterConfig)
/*     */     throws Exception
/*     */   {
/*  73 */     AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
/*     */ 
/*  77 */     NodeList filterChildren = filterConfig.getChildNodes();
/*     */ 
/*  79 */     for (int i = 0; i < filterChildren.getLength(); i++)
/*     */     {
/*  81 */       Node filterChildNode = filterChildren.item(i);
/*     */ 
/*  84 */       if (!filterChildNode.getNodeName().equals("enable")) {
/*     */         continue;
/*     */       }
/*  87 */       if (((Element)filterChildNode).hasAttribute("attribute-name"))
/*     */       {
/*  89 */         String attributeName = ((Element)filterChildNode).getAttribute("attribute-name");
/*     */ 
/*  91 */         filter.enableAttribute(attributeName);
/*     */       }
/*     */       else
/*     */       {
/*  95 */         throw new Exception("'enable' element must have a 'attribute-name' attribute");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 101 */     return filter;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.filterfactory.AttributeChangeNotificationFilterFactory
 * JD-Core Version:    0.6.0
 */