/*     */ package org.jboss.system.deployers;
/*     */ 
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Set;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractTopLevelClassLoaderDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
/*     */ import org.jboss.deployers.vfs.spi.structure.helpers.ClassPathVisitor;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ import org.jboss.system.ServiceController;
/*     */ import org.jboss.system.metadata.ServiceDeployment;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class ServiceClassLoaderDeployer extends AbstractTopLevelClassLoaderDeployer
/*     */ {
/*     */   private final ServiceController controller;
/*     */ 
/*     */   public ServiceClassLoaderDeployer(ServiceController controller)
/*     */   {
/*  66 */     if (controller == null)
/*  67 */       throw new IllegalArgumentException("Null controller");
/*  68 */     this.controller = controller;
/*     */   }
/*     */ 
/*     */   public ClassLoader createTopLevelClassLoader(DeploymentContext context) throws Exception
/*     */   {
/*  73 */     MBeanServer server = this.controller.getMBeanServer();
/*  74 */     DeploymentUnit unit = context.getDeploymentUnit();
/*     */ 
/*  76 */     VirtualFile root = null;
/*  77 */     URL url = null;
/*  78 */     if ((context instanceof VFSDeploymentContext))
/*     */     {
/*  80 */       VFSDeploymentContext vfsContext = (VFSDeploymentContext)context;
/*     */ 
/*  83 */       root = vfsContext.getRoot();
/*     */       try
/*     */       {
/*  86 */         if (root != null)
/*  87 */           url = trimJARURL(root.toURL());
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*  91 */         this.log.debug("Unable to get URL for " + context.getName() + " reason=" + ignored);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  96 */     LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig = (LoaderRepositoryFactory.LoaderRepositoryConfig)unit.getAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class);
/*  97 */     if (loaderConfig != null) {
/*  98 */       this.log.debug("Using loader repository config: " + loaderConfig.repositoryName);
/*     */     }
/*     */ 
/* 101 */     if (loaderConfig == null)
/*     */     {
/* 103 */       loaderConfig = new LoaderRepositoryFactory.LoaderRepositoryConfig();
/* 104 */       unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, loaderConfig);
/* 105 */       this.log.trace("Using default loader repository config: " + loaderConfig.repositoryName);
/*     */     }
/*     */ 
/* 108 */     LoaderRepositoryFactory.createLoaderRepository(server, loaderConfig);
/*     */ 
/* 111 */     Object[] args = { url, url, Boolean.TRUE };
/* 112 */     String[] sig = { "java.net.URL", "java.net.URL", "boolean" };
/* 113 */     RepositoryClassLoader ucl = (RepositoryClassLoader)server.invoke(loaderConfig.repositoryName, "newClassLoader", args, sig);
/*     */     try
/*     */     {
/* 118 */       ClassPathVisitor visitor = new ClassPathVisitor();
/* 119 */       context.visit(visitor);
/* 120 */       Set classpath = visitor.getClassPath();
/* 121 */       for (VirtualFile path : classpath)
/*     */       {
/* 124 */         if (path != root) {
/* 125 */           ucl.addURL(trimJARURL(path.toURL()));
/*     */         }
/*     */       }
/*     */ 
/* 129 */       ObjectName uclName = ucl.getObjectName();
/* 130 */       if (!server.isRegistered(uclName))
/* 131 */         server.registerMBean(ucl, uclName);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 135 */       internalRemoveClassLoader(context, ucl);
/* 136 */       throw DeploymentException.rethrowAsDeploymentException("Error creating classloader: " + context.getName(), t);
/*     */     }
/*     */ 
/* 139 */     return ucl;
/*     */   }
/*     */ 
/*     */   public void removeTopLevelClassLoader(DeploymentContext context)
/*     */   {
/* 144 */     RepositoryClassLoader ucl = (RepositoryClassLoader)context.getClassLoader();
/* 145 */     if (ucl == null)
/* 146 */       return;
/* 147 */     internalRemoveClassLoader(context, ucl);
/*     */   }
/*     */ 
/*     */   private void internalRemoveClassLoader(DeploymentContext context, RepositoryClassLoader ucl)
/*     */   {
/* 158 */     MBeanServer server = this.controller.getMBeanServer();
/*     */     try
/*     */     {
/* 163 */       ObjectName uclName = ucl.getObjectName();
/* 164 */       if (server.isRegistered(uclName) == true)
/* 165 */         server.unregisterMBean(uclName);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 169 */       this.log.warn("Error unregistering classloader mbean: " + ucl + " for " + context.getName(), t);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 175 */       ucl.unregister();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 179 */       this.log.warn("Error unregistering ucl: " + ucl + " for " + context.getName(), t);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 186 */       DeploymentUnit unit = context.getDeploymentUnit();
/* 187 */       ServiceDeployment deployment = (ServiceDeployment)unit.getAttachment(ServiceDeployment.class);
/* 188 */       if (deployment != null)
/*     */       {
/* 190 */         LoaderRepositoryFactory.LoaderRepositoryConfig config = (LoaderRepositoryFactory.LoaderRepositoryConfig)unit.getAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class);
/* 191 */         if (config != null)
/* 192 */           LoaderRepositoryFactory.destroyLoaderRepository(server, config.repositoryName);
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 197 */       this.log.warn("Error removing classloader from repository: " + ucl + " for " + context.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   private URL trimJARURL(URL url)
/*     */     throws MalformedURLException
/*     */   {
/* 204 */     String temp = url.toString();
/* 205 */     if ((temp.startsWith("jar:")) && (temp.endsWith("!/")))
/*     */     {
/* 207 */       temp = temp.substring(4, temp.length() - 2);
/* 208 */       return new URL(temp);
/*     */     }
/* 210 */     return url;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.deployers.ServiceClassLoaderDeployer
 * JD-Core Version:    0.6.0
 */