/*     */ package org.jboss.system.deployers;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.vfs.spi.deployer.JAXPDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.factory.ManagedObjectFactory;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ import org.jboss.system.deployers.managed.ServiceMetaDataICF;
/*     */ import org.jboss.system.metadata.ServiceDeployment;
/*     */ import org.jboss.system.metadata.ServiceDeploymentClassPath;
/*     */ import org.jboss.system.metadata.ServiceDeploymentParser;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public class SARDeployer extends JAXPDeployer<ServiceDeployment>
/*     */ {
/*     */   private ServiceMetaDataICF icf;
/*     */ 
/*     */   public SARDeployer()
/*     */   {
/*  66 */     super(ServiceDeployment.class);
/*  67 */     setSuffix("-service.xml");
/*     */ 
/*  69 */     setBuildManagedObject(true);
/*     */   }
/*     */ 
/*     */   public ServiceMetaDataICF getIcf()
/*     */   {
/*  74 */     return this.icf;
/*     */   }
/*     */ 
/*     */   public void setIcf(ServiceMetaDataICF icf)
/*     */   {
/*  79 */     this.icf = icf;
/*     */ 
/*  81 */     if (icf != null)
/*     */     {
/*  84 */       ManagedObjectFactory mof = ManagedObjectFactory.getInstance();
/*  85 */       mof.setInstanceClassFactory(ServiceMetaData.class, icf);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ServiceDeployment parse(VFSDeploymentUnit unit, VirtualFile file, Document document)
/*     */     throws Exception
/*     */   {
/*  97 */     ServiceDeploymentParser parser = new ServiceDeploymentParser(document);
/*  98 */     ServiceDeployment parsed = parser.parse();
/*  99 */     String name = file.toURI().toString();
/* 100 */     parsed.setName(name);
/*     */ 
/* 102 */     List classPaths = parsed.getClassPaths();
/* 103 */     if (classPaths != null) {
/* 104 */       processXMLClasspath(unit, classPaths);
/*     */     }
/* 106 */     LoaderRepositoryFactory.LoaderRepositoryConfig config = parsed.getLoaderRepositoryConfig();
/* 107 */     if (config != null)
/* 108 */       unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class.getName(), config);
/* 109 */     return parsed;
/*     */   }
/*     */ 
/*     */   private void processXMLClasspath(VFSDeploymentUnit unit, List<ServiceDeploymentClassPath> classpaths)
/*     */     throws Exception
/*     */   {
/* 121 */     ArrayList classpath = new ArrayList();
/*     */ 
/* 123 */     for (ServiceDeploymentClassPath path : classpaths)
/*     */     {
/* 125 */       String codebase = path.getCodeBase();
/* 126 */       String archives = path.getArchives();
/*     */ 
/* 128 */       this.log.debug("Processing classpath: " + unit.getName() + " codebase=" + codebase + " archives=" + archives);
/* 129 */       VirtualFile codebaseFile = unit.getRoot();
/* 130 */       if (!".".equals(codebase))
/*     */       {
/* 132 */         ServerConfig config = ServerConfigLocator.locate();
/* 133 */         URL codeBaseURL = new URL(config.getServerHomeURL(), codebase);
/* 134 */         codebaseFile = VFS.getVirtualFile(codeBaseURL, "");
/*     */       }
/*     */ 
/* 137 */       if (codebaseFile == null) {
/* 138 */         throw new DeploymentException("Cannot use classpath without a root: " + unit.getName());
/*     */       }
/* 140 */       if (archives == null)
/*     */       {
/* 142 */         classpath.add(codebaseFile);
/* 143 */         this.log.debug("Using codebase as classpath: " + unit.getName());
/*     */       }
/*     */       else
/*     */       {
/* 147 */         SARArchiveFilter filter = new SARArchiveFilter(archives);
/* 148 */         List archiveFiles = codebaseFile.getChildren(filter);
/* 149 */         classpath.addAll(archiveFiles);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 154 */     List origClassPath = unit.getClassPath();
/* 155 */     if (origClassPath != null)
/* 156 */       classpath.addAll(origClassPath);
/* 157 */     unit.setClassPath(classpath);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.deployers.SARDeployer
 * JD-Core Version:    0.6.0
 */