/*    */ package org.jboss.system.deployers;
/*    */ 
/*    */ import java.util.HashSet;
/*    */ import java.util.Set;
/*    */ import java.util.StringTokenizer;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ import org.jboss.virtual.VirtualFileFilter;
/*    */ 
/*    */ public class SARArchiveFilter
/*    */   implements VirtualFileFilter
/*    */ {
/*    */   private final Set<String> patterns;
/*    */   private final boolean allowAll;
/*    */ 
/*    */   public SARArchiveFilter(String patternsString)
/*    */   {
/* 53 */     if (patternsString == null) {
/* 54 */       throw new IllegalArgumentException("Null patternsString");
/*    */     }
/* 56 */     StringTokenizer tokens = new StringTokenizer(patternsString, ",");
/* 57 */     this.patterns = new HashSet(tokens.countTokens());
/* 58 */     for (int i = 0; tokens.hasMoreTokens(); i++)
/*    */     {
/* 60 */       String token = tokens.nextToken();
/* 61 */       this.patterns.add(token.trim());
/*    */     }
/* 63 */     this.allowAll = this.patterns.contains("*");
/*    */   }
/*    */ 
/*    */   public boolean accepts(VirtualFile file)
/*    */   {
/* 68 */     if (this.allowAll)
/* 69 */       return true;
/* 70 */     return this.patterns.contains(file.getName());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.deployers.SARArchiveFilter
 * JD-Core Version:    0.6.0
 */