/*     */ package org.jboss.system.deployers;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.util.Properties;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployers.plugins.classloading.ClassLoading;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
/*     */ import org.jboss.deployers.structure.spi.classloading.ExportAll;
/*     */ import org.jboss.deployers.structure.spi.classloading.Version;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ 
/*     */ public class HackClassloaderMetaDataDeployer extends AbstractRealDeployer
/*     */ {
/*     */   private ClassLoading classLoading;
/*     */ 
/*     */   public ClassLoading getClassLoading()
/*     */   {
/*  55 */     return this.classLoading;
/*     */   }
/*     */ 
/*     */   public void setClassLoading(ClassLoading classLoading)
/*     */   {
/*  60 */     this.classLoading = classLoading;
/*     */   }
/*     */ 
/*     */   public HackClassloaderMetaDataDeployer()
/*     */   {
/*  65 */     setStage(DeploymentStages.DESCRIBE);
/*     */   }
/*     */ 
/*     */   public void internalDeploy(DeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*  71 */     LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig = (LoaderRepositoryFactory.LoaderRepositoryConfig)unit.getAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class);
/*  72 */     if (loaderConfig != null)
/*     */     {
/*  74 */       this.log.debug("Using loader repository config: " + loaderConfig.repositoryName);
/*  75 */       ObjectName name = loaderConfig.repositoryName;
/*  76 */       if (name != null)
/*     */       {
/*  78 */         String domain = name.getCanonicalName().trim();
/*  79 */         if (domain.length() != 0)
/*     */         {
/*  81 */           ClassLoaderMetaData metaData = new ClassLoaderMetaData();
/*  82 */           metaData.setName(unit.getName());
/*  83 */           metaData.setDomain(domain);
/*  84 */           metaData.setExportAll(ExportAll.NON_EMPTY);
/*  85 */           metaData.setImportAll(true);
/*  86 */           metaData.setVersion(Version.DEFAULT_VERSION);
/*     */ 
/*  88 */           Properties props = new Properties();
/*  89 */           String config = loaderConfig.repositoryConfig;
/*     */           try
/*     */           {
/*  92 */             if (config != null)
/*     */             {
/*  94 */               ByteArrayInputStream bais = new ByteArrayInputStream(config.getBytes());
/*  95 */               props.load(bais);
/*     */             }
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 100 */             throw DeploymentException.rethrowAsDeploymentException("Error parsing repository config " + config, e);
/*     */           }
/* 102 */           String java2ParentDelegation = props.getProperty("java2ParentDelegation");
/* 103 */           if (java2ParentDelegation == null)
/*     */           {
/* 106 */             java2ParentDelegation = props.getProperty("java2ParentDelegaton", "false");
/*     */           }
/* 108 */           boolean useParentFirst = Boolean.valueOf(java2ParentDelegation).booleanValue();
/* 109 */           metaData.setJ2seClassLoadingCompliance(useParentFirst);
/*     */ 
/* 111 */           unit.addAttachment(ClassLoaderMetaData.class, metaData);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 116 */     this.classLoading.addDeploymentUnit(unit);
/*     */   }
/*     */ 
/*     */   public void internalUndeploy(DeploymentUnit unit)
/*     */   {
/* 121 */     this.classLoading.removeDeploymentUnit(unit);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.deployers.HackClassloaderMetaDataDeployer
 * JD-Core Version:    0.6.0
 */