/*     */ package org.jboss.system;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectInstance;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.StandardMBean;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.server.registry.MBeanEntry;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.system.metadata.ServiceConstructorMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaDataParser;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ServiceCreator
/*     */ {
/*  58 */   private static final Logger log = Logger.getLogger(ServiceCreator.class);
/*     */ 
/*  61 */   private static ObjectName MBEAN_REGISTRY = ObjectNameFactory.create("JMImplementation:type=MBeanRegistry");
/*     */   private MBeanServer server;
/*     */ 
/*     */   public static ServiceInstance install(MBeanServer server, ObjectName objectName, ServiceMetaData metaData, Object mbean)
/*     */     throws Exception
/*     */   {
/*  79 */     if (server == null)
/*  80 */       throw new IllegalArgumentException("Null MBeanServer");
/*  81 */     if (objectName == null)
/*  82 */       throw new IllegalArgumentException("Null ObjectName");
/*  83 */     if ((metaData == null) && (mbean == null)) {
/*  84 */       throw new IllegalArgumentException("Either metadata or an mbean object must be supplied");
/*     */     }
/*     */ 
/*  87 */     if (server.isRegistered(objectName)) {
/*  88 */       throw new DeploymentException("Trying to install an already registered mbean: " + objectName);
/*     */     }
/*     */     try
/*     */     {
/*  92 */       ServiceInstance result = null;
/*     */ 
/*  95 */       if (metaData == null)
/*     */       {
/*  97 */         ObjectInstance instance = server.registerMBean(mbean, objectName);
/*  98 */         result = new ServiceInstance(instance, mbean);
/*     */       }
/*     */       else
/*     */       {
/* 102 */         String code = metaData.getCode();
/* 103 */         if ((code == null) || (code.trim().length() == 0)) {
/* 104 */           throw new ConfigurationException("Missing or empty code for mbean " + objectName);
/*     */         }
/* 106 */         String xmbeanDD = metaData.getXMBeanDD();
/*     */ 
/* 109 */         if (xmbeanDD == null)
/*     */         {
/* 111 */           String interfaceName = metaData.getInterfaceName();
/* 112 */           if (interfaceName != null)
/* 113 */             result = installStandardMBean(server, objectName, metaData);
/*     */           else {
/* 115 */             result = installPlainMBean(server, objectName, metaData);
/*     */           }
/*     */         }
/* 118 */         else if (xmbeanDD.length() == 0) {
/* 119 */           result = installEmbeddedXMBean(server, objectName, metaData);
/*     */         }
/*     */         else {
/* 122 */           result = installExternalXMBean(server, objectName, metaData);
/*     */         }
/*     */       }
/* 125 */       log.debug("Created mbean: " + objectName);
/* 126 */       return result;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 130 */       Throwable newE = JMXExceptionDecoder.decode(e);
/*     */       try
/*     */       {
/* 135 */         server.unregisterMBean(objectName);
/*     */       }
/*     */       catch (Throwable ignore)
/*     */       {
/*     */       }
/*     */ 
/* 141 */       DeploymentException.rethrowAsDeploymentException("Unable to createMBean for " + objectName, newE);
/* 142 */     }throw new UnreachableStatementException();
/*     */   }
/*     */ 
/*     */   private static ServiceInstance installStandardMBean(MBeanServer server, ObjectName objectName, ServiceMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 157 */     ObjectName loaderName = metaData.getClassLoaderName();
/* 158 */     ClassLoader loader = server.getClassLoader(loaderName);
/* 159 */     String code = metaData.getCode();
/* 160 */     ServiceConstructorMetaData constructor = metaData.getConstructor();
/* 161 */     String interfaceName = metaData.getInterfaceName();
/*     */ 
/* 163 */     Class intf = loader.loadClass(interfaceName);
/* 164 */     log.debug("About to create bean resource: " + objectName + " with code: " + code + " and interface " + interfaceName);
/* 165 */     Object resource = server.instantiate(code, loaderName, constructor.getParameters(loader), constructor.getSignature());
/*     */ 
/* 170 */     log.debug("About to register StandardMBean : " + objectName);
/* 171 */     ObjectInstance instance = server.createMBean(StandardMBean.class.getName(), objectName, loaderName, new Object[] { resource, intf }, new String[] { Object.class.getName(), Class.class.getName() });
/*     */ 
/* 176 */     return new ServiceInstance(instance, resource);
/*     */   }
/*     */ 
/*     */   private static ServiceInstance installPlainMBean(MBeanServer server, ObjectName objectName, ServiceMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 190 */     ObjectName loaderName = metaData.getClassLoaderName();
/* 191 */     ClassLoader loader = server.getClassLoader(loaderName);
/* 192 */     String code = metaData.getCode();
/* 193 */     ServiceConstructorMetaData constructor = metaData.getConstructor();
/*     */ 
/* 196 */     log.debug("About to create bean: " + objectName + " with code: " + code);
/* 197 */     ObjectInstance instance = server.createMBean(code, objectName, loaderName, constructor.getParameters(loader), constructor.getSignature());
/*     */ 
/* 203 */     MBeanEntry entry = (MBeanEntry)server.invoke(MBEAN_REGISTRY, "get", new Object[] { objectName }, new String[] { ObjectName.class.getName() });
/* 204 */     Object resource = entry.getResourceInstance();
/* 205 */     return new ServiceInstance(instance, resource);
/*     */   }
/*     */ 
/*     */   private static ServiceInstance installEmbeddedXMBean(MBeanServer server, ObjectName objectName, ServiceMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 219 */     ObjectName loaderName = metaData.getClassLoaderName();
/* 220 */     ClassLoader loader = server.getClassLoader(loaderName);
/* 221 */     String code = metaData.getCode();
/* 222 */     ServiceConstructorMetaData constructor = metaData.getConstructor();
/*     */ 
/* 225 */     log.debug("About to create xmbean object: " + objectName + " with code: " + code + " with embedded descriptor");
/*     */ 
/* 227 */     Object resource = server.instantiate(code, loaderName, constructor.getParameters(loader), constructor.getSignature());
/*     */ 
/* 232 */     String xmbeanCode = metaData.getXMBeanCode();
/* 233 */     Element mbeanDescriptor = metaData.getXMBeanDescriptor();
/* 234 */     Object[] args = { resource, mbeanDescriptor, "-//JBoss//DTD JBOSS XMBEAN 1.0//EN" };
/* 235 */     String[] sig = { Object.class.getName(), Element.class.getName(), String.class.getName() };
/* 236 */     ObjectInstance instance = server.createMBean(xmbeanCode, objectName, loaderName, args, sig);
/*     */ 
/* 241 */     return new ServiceInstance(instance, resource);
/*     */   }
/*     */ 
/*     */   private static ServiceInstance installExternalXMBean(MBeanServer server, ObjectName objectName, ServiceMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 255 */     ObjectName loaderName = metaData.getClassLoaderName();
/* 256 */     ClassLoader loader = server.getClassLoader(loaderName);
/* 257 */     String code = metaData.getCode();
/* 258 */     ServiceConstructorMetaData constructor = metaData.getConstructor();
/* 259 */     String xmbeanDD = metaData.getXMBeanDD();
/*     */ 
/* 262 */     log.debug("About to create xmbean object: " + objectName + " with code: " + code + " with descriptor: " + xmbeanDD);
/*     */ 
/* 264 */     Object resource = server.instantiate(code, loaderName, constructor.getParameters(loader), constructor.getSignature());
/*     */ 
/* 269 */     URL xmbeanddUrl = null;
/*     */     try
/*     */     {
/* 272 */       xmbeanddUrl = resource.getClass().getClassLoader().getResource(xmbeanDD);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 278 */     if (xmbeanddUrl == null) {
/* 279 */       xmbeanddUrl = new URL(xmbeanDD);
/*     */     }
/* 281 */     String xmbeanCode = metaData.getXMBeanCode();
/*     */ 
/* 284 */     Object[] args = { resource, xmbeanddUrl };
/* 285 */     String[] sig = { Object.class.getName(), URL.class.getName() };
/* 286 */     ObjectInstance instance = server.createMBean(xmbeanCode, objectName, loaderName, args, sig);
/*     */ 
/* 291 */     return new ServiceInstance(instance, resource);
/*     */   }
/*     */ 
/*     */   public static void uninstall(MBeanServer server, ObjectName objectName)
/*     */   {
/* 302 */     if (server == null)
/* 303 */       throw new IllegalArgumentException("Null MBeanServer");
/* 304 */     if (objectName == null)
/* 305 */       throw new IllegalArgumentException("Null ObjectName");
/*     */     try
/*     */     {
/* 308 */       log.debug("Removing mbean from server: " + objectName);
/* 309 */       server.unregisterMBean(objectName);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 313 */       log.debug("Error unregistering mbean " + objectName, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public ServiceCreator(MBeanServer server)
/*     */   {
/* 325 */     if (server == null)
/* 326 */       throw new IllegalArgumentException("Null MBeanServer");
/* 327 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 335 */     this.server = null;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public ObjectInstance install(ObjectName mbeanName, ObjectName loaderName, Element mbeanElement)
/*     */     throws Exception
/*     */   {
/* 351 */     if (mbeanName == null)
/* 352 */       throw new IllegalArgumentException("Null mbeanName");
/* 353 */     if (mbeanElement == null) {
/* 354 */       throw new IllegalArgumentException("Null mbean element");
/*     */     }
/* 356 */     ServiceMetaDataParser parser = new ServiceMetaDataParser(mbeanElement);
/* 357 */     List metaDatas = parser.parse();
/* 358 */     if (metaDatas.isEmpty())
/* 359 */       throw new DeploymentException("No mbeans found in passed configuration for " + mbeanName);
/* 360 */     ServiceMetaData metaData = (ServiceMetaData)metaDatas.get(0);
/* 361 */     metaData.setClassLoaderName(loaderName);
/* 362 */     ServiceInstance instance = install(this.server, mbeanName, metaData, null);
/* 363 */     return instance.getObjectInstance();
/*     */   }
/*     */ 
/*     */   public void remove(ObjectName name)
/*     */     throws Exception
/*     */   {
/* 374 */     if (name == null)
/* 375 */       throw new IllegalArgumentException("Null name");
/* 376 */     uninstall(this.server, name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.ServiceCreator
 * JD-Core Version:    0.6.0
 */