/*     */ package org.jboss.system;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.Notification;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.deployment.DeploymentState;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaDataParser;
/*     */ import org.jboss.system.microcontainer.LifecycleDependencyItem;
/*     */ import org.jboss.system.microcontainer.ServiceControllerContext;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ServiceController extends JBossNotificationBroadcasterSupport
/*     */   implements ServiceControllerMBean, MBeanRegistration
/*     */ {
/*  82 */   public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create("JMImplementation:service=LoaderRepository,name=Default");
/*     */   public static final String JBOSS_INTERNAL_LIFECYCLE = "jbossInternalLifecycle";
/*  88 */   public static final String[] JBOSS_INTERNAL_LIFECYCLE_SIG = { String.class.getName() };
/*     */ 
/*  91 */   private static final Logger log = Logger.getLogger(ServiceController.class);
/*     */   protected Kernel kernel;
/*     */   protected MBeanServer server;
/*     */   protected ServiceBinding serviceBinding;
/* 103 */   protected Map<ObjectName, ServiceControllerContext> installed = new ConcurrentHashMap();
/*     */ 
/* 106 */   protected CopyOnWriteArrayList<ServiceControllerContext> installedOrder = new CopyOnWriteArrayList();
/*     */ 
/*     */   public MBeanServer getMBeanServer()
/*     */   {
/* 115 */     return this.server;
/*     */   }
/*     */ 
/*     */   public void setMBeanServer(MBeanServer server)
/*     */   {
/* 125 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public Kernel getKernel()
/*     */   {
/* 135 */     return this.kernel;
/*     */   }
/*     */ 
/*     */   public void setKernel(Kernel kernel)
/*     */   {
/* 145 */     this.kernel = kernel;
/*     */   }
/*     */ 
/*     */   public ServiceBinding getServiceBinding()
/*     */   {
/* 155 */     return this.serviceBinding;
/*     */   }
/*     */ 
/*     */   public void setServiceBinding(ServiceBinding serviceBinding)
/*     */   {
/* 165 */     this.serviceBinding = serviceBinding;
/*     */   }
/*     */ 
/*     */   public List<ServiceContext> listDeployed()
/*     */   {
/* 171 */     ArrayList result = new ArrayList(this.installedOrder.size());
/* 172 */     for (ServiceControllerContext context : this.installedOrder)
/* 173 */       result.add(context.getServiceContext());
/* 174 */     return result;
/*     */   }
/*     */ 
/*     */   public List<ServiceContext> listIncompletelyDeployed()
/*     */   {
/* 180 */     ArrayList result = new ArrayList();
/* 181 */     for (ServiceControllerContext context : this.installedOrder)
/*     */     {
/* 183 */       ServiceContext sc = context.getServiceContext();
/* 184 */       if ((sc.state != 2) && (sc.state != 3) && (sc.state != 5) && (sc.state != 6))
/*     */       {
/* 189 */         result.add(sc);
/*     */       }
/*     */     }
/* 192 */     return result;
/*     */   }
/*     */ 
/*     */   public List<ObjectName> listDeployedNames()
/*     */   {
/* 198 */     ArrayList result = new ArrayList(this.installed.size());
/* 199 */     for (ObjectName name : this.installed.keySet())
/* 200 */       result.add(name);
/* 201 */     return result;
/*     */   }
/*     */ 
/*     */   public String listConfiguration(ObjectName[] objectNames) throws Exception
/*     */   {
/* 206 */     return ServiceConfigurator.getConfiguration(this.server, this, objectNames);
/*     */   }
/*     */ 
/*     */   public void validateDeploymentState(DeploymentInfo di, DeploymentState state)
/*     */   {
/* 211 */     ArrayList mbeans = new ArrayList(di.mbeans);
/* 212 */     if (di.deployedObject != null)
/* 213 */       mbeans.add(di.deployedObject);
/* 214 */     boolean mbeansStateIsValid = true;
/* 215 */     for (int m = 0; m < mbeans.size(); m++)
/*     */     {
/* 217 */       ObjectName serviceName = (ObjectName)mbeans.get(m);
/* 218 */       ServiceContext ctx = getServiceContext(serviceName);
/* 219 */       if ((ctx != null) && (state == DeploymentState.STARTED))
/* 220 */         mbeansStateIsValid &= ctx.state == 3;
/*     */     }
/* 222 */     if (mbeansStateIsValid == true)
/* 223 */       di.state = state;
/*     */   }
/*     */ 
/*     */   public List<ObjectName> install(List<ServiceMetaData> metaDatas, ObjectName loaderName) throws DeploymentException
/*     */   {
/* 228 */     KernelController controller = this.kernel.getController();
/*     */ 
/* 232 */     List result = new ArrayList(metaDatas.size());
/* 233 */     List contexts = new ArrayList(metaDatas.size());
/*     */ 
/* 236 */     for (ServiceMetaData metaData : metaDatas)
/*     */     {
/* 238 */       metaData.setClassLoaderName(loaderName);
/*     */ 
/* 241 */       ServiceControllerContext context = new ServiceControllerContext(this, metaData);
/*     */       try
/*     */       {
/* 244 */         doInstall(controller, context);
/* 245 */         contexts.add(context);
/* 246 */         doChange(controller, context, ControllerState.CONFIGURED, "configure");
/* 247 */         result.add(context.getObjectName());
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 252 */         for (ServiceControllerContext ctx : contexts) {
/* 253 */           safelyRemoveAnyRegisteredContext(ctx);
/*     */         }
/* 255 */         DeploymentException.rethrowAsDeploymentException("Error during install", t);
/*     */       }
/*     */     }
/* 258 */     return result;
/*     */   }
/*     */ 
/*     */   public ObjectName install(ServiceMetaData metaData, ObjectName loaderName) throws DeploymentException
/*     */   {
/* 263 */     KernelController controller = this.kernel.getController();
/* 264 */     metaData.setClassLoaderName(loaderName);
/* 265 */     ObjectName name = metaData.getObjectName();
/*     */ 
/* 268 */     ServiceControllerContext context = new ServiceControllerContext(this, metaData);
/*     */     try
/*     */     {
/* 271 */       doInstall(controller, context);
/* 272 */       doChange(controller, context, ControllerState.CONFIGURED, "configure");
/* 273 */       return context.getObjectName();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 277 */     throw DeploymentException.rethrowAsDeploymentException("Error during install " + name, t);
/*     */   }
/*     */ 
/*     */   public List<ObjectName> install(Element config, ObjectName loaderName)
/*     */     throws DeploymentException
/*     */   {
/* 284 */     ServiceMetaDataParser parser = new ServiceMetaDataParser(config);
/* 285 */     List metaDatas = parser.parse();
/* 286 */     return install(metaDatas, loaderName);
/*     */   }
/*     */ 
/*     */   public void install(ObjectName name, Object object)
/*     */     throws DeploymentException
/*     */   {
/* 298 */     if (name == null)
/* 299 */       throw new IllegalArgumentException("Null name");
/* 300 */     if (object == null) {
/* 301 */       throw new IllegalArgumentException("Null object");
/*     */     }
/* 303 */     KernelController controller = this.kernel.getController();
/*     */ 
/* 305 */     ServiceControllerContext context = new ServiceControllerContext(this, name, object);
/*     */     try
/*     */     {
/* 308 */       doInstall(controller, context);
/* 309 */       doChange(controller, context, ControllerState.CONFIGURED, "configure");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 314 */       safelyRemoveAnyRegisteredContext(context);
/*     */ 
/* 316 */       DeploymentException.rethrowAsDeploymentException("Error during install", t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void register(ObjectName serviceName) throws Exception
/*     */   {
/* 322 */     register(serviceName, null);
/*     */   }
/*     */ 
/*     */   public void register(ObjectName serviceName, Collection<ObjectName> depends) throws Exception
/*     */   {
/* 327 */     if (serviceName == null)
/*     */     {
/* 329 */       log.warn("Ignoring request to register null service: ", new Exception("STACKTRACE"));
/* 330 */       return;
/*     */     }
/*     */ 
/* 333 */     log.debug("Registering service " + serviceName);
/*     */ 
/* 336 */     KernelController controller = this.kernel.getController();
/* 337 */     ServiceControllerContext context = new ServiceControllerContext(this, serviceName);
/* 338 */     if (depends != null) {
/* 339 */       addDependencies(context, depends);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 344 */       doInstall(controller, context);
/* 345 */       doChange(controller, context, ControllerState.CONFIGURED, "configure");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 350 */       safelyRemoveAnyRegisteredContext(context);
/*     */ 
/* 352 */       DeploymentException.rethrowAsDeploymentException("Error during register: " + serviceName, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void create(ObjectName serviceName) throws Exception
/*     */   {
/* 358 */     create(serviceName, null);
/*     */   }
/*     */ 
/*     */   public void create(ObjectName serviceName, Collection<ObjectName> depends) throws Exception
/*     */   {
/* 363 */     if (serviceName == null)
/*     */     {
/* 365 */       log.warn("Ignoring request to create null service: ", new Exception("STACKTRACE"));
/* 366 */       return;
/*     */     }
/*     */ 
/* 369 */     log.debug("Creating service " + serviceName);
/*     */ 
/* 372 */     ServiceControllerContext context = (ServiceControllerContext)this.installed.get(serviceName);
/* 373 */     if (context == null)
/*     */     {
/* 375 */       register(serviceName, depends);
/* 376 */       context = (ServiceControllerContext)this.installed.get(serviceName);
/*     */     }
/* 378 */     ServiceContext ctx = context.getServiceContext();
/*     */ 
/* 381 */     if ((ctx.state == 2) || (ctx.state == 3) || (ctx.state == 4))
/*     */     {
/* 385 */       log.debug("Ignoring create request for service: " + ctx.objectName + " at state " + ctx.getStateString());
/* 386 */       return;
/*     */     }
/*     */ 
/* 390 */     KernelController controller = this.kernel.getController();
/*     */     try
/*     */     {
/* 393 */       doChange(controller, context, ControllerState.CREATE, "create");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 397 */       log.warn("Problem creating service " + serviceName, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start(ObjectName serviceName) throws Exception
/*     */   {
/* 403 */     if (serviceName == null)
/*     */     {
/* 405 */       log.warn("Ignoring request to start null service: ", new Exception("STACKTRACE"));
/* 406 */       return;
/*     */     }
/*     */ 
/* 409 */     log.debug("starting service " + serviceName);
/*     */ 
/* 412 */     ServiceControllerContext context = (ServiceControllerContext)this.installed.get(serviceName);
/* 413 */     if (context == null)
/*     */     {
/* 415 */       register(serviceName, null);
/* 416 */       context = (ServiceControllerContext)this.installed.get(serviceName);
/*     */     }
/* 418 */     ServiceContext ctx = context.getServiceContext();
/*     */ 
/* 421 */     if ((ctx.state == 3) || (ctx.state == 4))
/*     */     {
/* 423 */       log.debug("Ignoring start request for service: " + ctx.objectName + " at state " + ctx.getStateString());
/* 424 */       return;
/*     */     }
/*     */ 
/* 428 */     KernelController controller = this.kernel.getController();
/*     */     try
/*     */     {
/* 431 */       doChange(controller, context, ControllerState.INSTALLED, "start");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 435 */       log.warn("Problem starting service " + serviceName, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void restart(ObjectName serviceName) throws Exception
/*     */   {
/* 441 */     if (serviceName == null)
/*     */     {
/* 443 */       log.warn("Ignoring request to restart null service: ", new Exception("STACKTRACE"));
/* 444 */       return;
/*     */     }
/*     */ 
/* 447 */     log.debug("restarting service " + serviceName);
/* 448 */     stop(serviceName);
/* 449 */     start(serviceName);
/*     */   }
/*     */ 
/*     */   public void stop(ObjectName serviceName) throws Exception
/*     */   {
/* 454 */     if (serviceName == null)
/*     */     {
/* 456 */       log.warn("Ignoring request to stop null service: ", new Exception("STACKTRACE"));
/* 457 */       return;
/*     */     }
/*     */ 
/* 460 */     log.debug("stopping service: " + serviceName);
/*     */ 
/* 462 */     ServiceControllerContext context = (ServiceControllerContext)this.installed.get(serviceName);
/* 463 */     if (context == null)
/*     */     {
/* 465 */       log.warn("Ignoring request to stop nonexistent service: " + serviceName);
/* 466 */       return;
/*     */     }
/*     */ 
/* 470 */     ServiceContext ctx = context.getServiceContext();
/* 471 */     if (ctx.state != 3)
/*     */     {
/* 473 */       log.debug("Ignoring stop request for service: " + ctx.objectName + " at state " + ctx.getStateString());
/* 474 */       return;
/*     */     }
/*     */ 
/* 478 */     KernelController controller = this.kernel.getController();
/*     */     try
/*     */     {
/* 481 */       doChange(controller, context, ControllerState.CREATE, null);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 485 */       log.warn("Problem stopping service " + serviceName, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy(ObjectName serviceName) throws Exception
/*     */   {
/* 491 */     if (serviceName == null)
/*     */     {
/* 493 */       log.warn("Ignoring request to destroy null service: ", new Exception("STACKTRACE"));
/* 494 */       return;
/*     */     }
/*     */ 
/* 497 */     log.debug("destroying service: " + serviceName);
/*     */ 
/* 499 */     ServiceControllerContext context = (ServiceControllerContext)this.installed.get(serviceName);
/* 500 */     if (context == null)
/*     */     {
/* 502 */       log.warn("Ignoring request to destroy nonexistent service: " + serviceName);
/* 503 */       return;
/*     */     }
/*     */ 
/* 507 */     ServiceContext ctx = context.getServiceContext();
/* 508 */     if ((ctx.state == 6) || (ctx.state == 7) || (ctx.state == 4))
/*     */     {
/* 510 */       log.debug("Ignoring destroy request for service: " + ctx.objectName + " at state " + ctx.getStateString());
/* 511 */       return;
/*     */     }
/*     */ 
/* 515 */     KernelController controller = this.kernel.getController();
/*     */     try
/*     */     {
/* 518 */       doChange(controller, context, ControllerState.CONFIGURED, null);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 522 */       log.warn("Problem stopping service " + serviceName, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(ObjectName objectName) throws Exception
/*     */   {
/* 528 */     if (objectName == null)
/*     */     {
/* 530 */       log.warn("Ignoring request to remove null service: ", new Exception("STACKTRACE"));
/* 531 */       return;
/*     */     }
/*     */ 
/* 539 */     ServiceControllerContext context = (ServiceControllerContext)this.installed.remove(objectName);
/* 540 */     if (context == null)
/*     */     {
/* 542 */       log.trace("Ignoring request to remove nonexistent service: " + objectName);
/* 543 */       return;
/*     */     }
/* 545 */     this.installedOrder.remove(context);
/* 546 */     log.debug("removing service: " + objectName);
/*     */ 
/* 549 */     safelyRemoveAnyRegisteredContext(context);
/*     */   }
/*     */ 
/*     */   public ServiceContext getServiceContext(ObjectName serviceName)
/*     */   {
/* 554 */     ServiceControllerContext context = (ServiceControllerContext)this.installed.get(serviceName);
/* 555 */     if (context != null)
/* 556 */       return context.getServiceContext();
/* 557 */     return null;
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 562 */     log.debug("Stopping " + this.installedOrder.size() + " services");
/*     */ 
/* 564 */     KernelController controller = this.kernel.getController();
/*     */ 
/* 566 */     int serviceCounter = 0;
/*     */ 
/* 569 */     ListIterator iterator = this.installedOrder.listIterator(this.installedOrder.size());
/* 570 */     while (iterator.hasPrevious())
/*     */     {
/* 572 */       ServiceControllerContext context = (ServiceControllerContext)iterator.previous();
/* 573 */       controller.uninstall(context.getName());
/* 574 */       serviceCounter++;
/*     */     }
/* 576 */     log.debug("Stopped " + serviceCounter + " services");
/*     */ 
/* 579 */     controller.uninstall(MBeanRegistration.OBJECT_NAME.getCanonicalName());
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 585 */     this.server = server;
/*     */ 
/* 587 */     if (this.kernel == null)
/*     */     {
/* 590 */       BasicBootstrap bootstrap = new BasicBootstrap();
/* 591 */       bootstrap.run();
/* 592 */       this.kernel = bootstrap.getKernel();
/*     */     }
/*     */ 
/* 595 */     log.debug("Controller MBean online");
/* 596 */     return name == null ? OBJECT_NAME : name;
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/* 601 */     if (!registrationDone.booleanValue()) {
/* 602 */       log.fatal("Registration of ServiceController failed");
/*     */     }
/*     */     else
/*     */     {
/* 606 */       KernelController controller = this.kernel.getController();
/* 607 */       ServiceControllerContext context = new ServiceControllerContext(this, MBeanRegistration.OBJECT_NAME);
/* 608 */       context.setMode(ControllerMode.AUTOMATIC);
/*     */       try
/*     */       {
/* 611 */         controller.install(context);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 615 */         log.fatal("Error registering service controller", t);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void preDeregister()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/* 627 */     this.installed.clear();
/* 628 */     this.installedOrder.clear();
/* 629 */     this.server = null;
/*     */   }
/*     */ 
/*     */   private void doInstall(KernelController controller, ServiceControllerContext context)
/*     */     throws Throwable
/*     */   {
/* 641 */     controller.install(context);
/* 642 */     this.installed.put(context.getObjectName(), context);
/* 643 */     this.installedOrder.add(context);
/*     */   }
/*     */ 
/*     */   private void doChange(KernelController controller, ServiceControllerContext context, ControllerState requiredState, String logWait)
/*     */     throws Throwable
/*     */   {
/* 657 */     if (!ControllerMode.ON_DEMAND.equals(context.getMode()))
/*     */     {
/* 659 */       controller.change(context, requiredState);
/* 660 */       ControllerState state = context.getState();
/* 661 */       if ((logWait != null) && (!requiredState.equals(state)) && (state != ControllerState.ERROR))
/* 662 */         log.debug("Waiting in " + logWait + " of " + context.getObjectName() + " on " + getUnresolvedDependencies(context, requiredState));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void sendControllerNotification(String type, ObjectName serviceName)
/*     */   {
/* 674 */     Notification notification = new Notification(type, this, super.nextNotificationSequenceNumber());
/* 675 */     notification.setUserData(serviceName);
/* 676 */     sendNotification(notification);
/*     */   }
/*     */ 
/*     */   private void addDependencies(ServiceControllerContext context, Collection<ObjectName> depends)
/*     */   {
/* 687 */     DependencyInfo info = context.getDependencyInfo();
/* 688 */     for (ObjectName other : depends)
/*     */     {
/* 690 */       info.addIDependOn(new LifecycleDependencyItem(context.getName(), other.getCanonicalName(), ControllerState.CREATE));
/* 691 */       info.addIDependOn(new LifecycleDependencyItem(context.getName(), other.getCanonicalName(), ControllerState.START));
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getUnresolvedDependencies(ServiceControllerContext context, ControllerState state)
/*     */   {
/* 704 */     boolean first = true;
/*     */ 
/* 706 */     StringBuilder builder = new StringBuilder();
/* 707 */     for (DependencyItem item : context.getDependencyInfo().getUnresolvedDependencies())
/*     */     {
/* 709 */       if ((!item.isResolved()) && (item.getWhenRequired() == state))
/*     */       {
/* 711 */         if (first)
/* 712 */           first = false;
/*     */         else
/* 714 */           builder.append(' ');
/* 715 */         builder.append(item.getIDependOn());
/*     */       }
/*     */     }
/* 718 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   private void safelyRemoveAnyRegisteredContext(ServiceControllerContext ctx)
/*     */   {
/* 729 */     Controller controller = ctx.getController();
/* 730 */     if (controller != null)
/*     */     {
/* 733 */       Object name = ctx.getName();
/* 734 */       ControllerContext registered = controller.getContext(name, null);
/* 735 */       if (registered == ctx)
/* 736 */         controller.uninstall(name);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.ServiceController
 * JD-Core Version:    0.6.0
 */