/*     */ package org.jboss.system;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.StringWriter;
/*     */ import java.io.Writer;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.transform.Transformer;
/*     */ import javax.xml.transform.TransformerException;
/*     */ import javax.xml.transform.TransformerFactory;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.transform.stream.StreamResult;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaDataParser;
/*     */ import org.jboss.system.metadata.ServiceValueContext;
/*     */ import org.jboss.util.xml.DOMWriter;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class ServiceConfigurator
/*     */ {
/*     */   private final MBeanServer server;
/*     */   private final ServiceController serviceController;
/*     */   private final ServiceCreator serviceCreator;
/*     */   private ServiceBinding serviceBinding;
/*  86 */   private static final Logger log = Logger.getLogger(ServiceConfigurator.class);
/*     */ 
/*     */   public static void configure(MBeanServer server, ServiceController controller, ObjectName objectName, ObjectName classLoaderName, Collection<ServiceAttributeMetaData> attrs)
/*     */     throws Exception
/*     */   {
/* 100 */     server = checkMBeanServer(server, controller);
/* 101 */     ClassLoader cl = server.getClassLoader(classLoaderName);
/* 102 */     configure(server, controller, objectName, cl, attrs);
/*     */   }
/*     */ 
/*     */   public static void configure(MBeanServer server, ServiceController controller, ObjectName objectName, ClassLoader cl, Collection<ServiceAttributeMetaData> attrs)
/*     */     throws Exception
/*     */   {
/* 117 */     ServiceValueContext valueContext = new ServiceValueContext(server, controller, cl);
/* 118 */     server = checkMBeanServer(server, controller);
/*     */ 
/* 120 */     HashMap attributeMap = getAttributeMap(server, objectName);
/*     */ 
/* 122 */     for (ServiceAttributeMetaData attribute : attrs)
/*     */     {
/* 124 */       String attributeName = attribute.getName();
/* 125 */       if ((attributeName == null) || (attributeName.length() == 0))
/* 126 */         throw new DeploymentException("No or empty attribute name for " + objectName);
/* 127 */       MBeanAttributeInfo attributeInfo = (MBeanAttributeInfo)attributeMap.get(attributeName);
/* 128 */       if (attributeInfo == null)
/*     */       {
/* 130 */         throw new DeploymentException("No Attribute found with name: " + attributeName + " for " + objectName + ", attributes: " + attributeMap.keySet());
/*     */       }
/*     */ 
/* 134 */       valueContext.setAttributeInfo(attributeInfo);
/* 135 */       Object value = attribute.getValue(valueContext);
/*     */       try
/*     */       {
/* 138 */         log.debug(attributeName + " set to " + value + " in " + objectName);
/* 139 */         server.setAttribute(objectName, new Attribute(attributeName, value));
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 143 */         throw new DeploymentException("Exception setting attribute " + attributeName + " on mbean " + objectName, JMXExceptionDecoder.decode(t));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static MBeanServer checkMBeanServer(MBeanServer server, ServiceController controller)
/*     */   {
/* 157 */     if (server != null) {
/* 158 */       return server;
/*     */     }
/* 160 */     if (controller != null) {
/* 161 */       return controller.getMBeanServer();
/*     */     }
/* 163 */     throw new IllegalArgumentException("Either the server or controller must be passed");
/*     */   }
/*     */ 
/*     */   public static void applyServiceConfig(MBeanServer server, ObjectName objectName, ServiceBinding serviceBinding)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 179 */       serviceBinding.applyServiceConfig(objectName);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 184 */       Throwable t = JMXExceptionDecoder.decode(e);
/* 185 */       log.warn("Failed to apply service binding override for " + objectName, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static HashMap<String, MBeanAttributeInfo> getAttributeMap(MBeanServer server, ObjectName objectName)
/*     */     throws Exception
/*     */   {
/*     */     MBeanInfo info;
/*     */     try
/*     */     {
/* 202 */       info = server.getMBeanInfo(objectName);
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 207 */       throw new DeploymentException("Trying to configure nonexistent mbean: " + objectName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 211 */       throw new DeploymentException("Could not get mbeanInfo", JMXExceptionDecoder.decode(e));
/*     */     }
/* 213 */     if (info == null)
/* 214 */       throw new DeploymentException("MBeanInfo is null for mbean: " + objectName);
/* 215 */     MBeanAttributeInfo[] attributes = info.getAttributes();
/* 216 */     HashMap attributeMap = new HashMap();
/* 217 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/* 219 */       MBeanAttributeInfo attr = attributes[i];
/* 220 */       attributeMap.put(attr.getName(), attr);
/*     */     }
/*     */ 
/* 223 */     return attributeMap;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public ServiceConfigurator(MBeanServer server, ServiceController serviceController, ServiceCreator serviceCreator)
/*     */   {
/* 236 */     if (server == null)
/* 237 */       throw new IllegalArgumentException("Null server");
/* 238 */     if (serviceCreator == null) {
/* 239 */       throw new IllegalArgumentException("Null serverCreator");
/*     */     }
/* 241 */     this.server = server;
/* 242 */     this.serviceController = serviceController;
/* 243 */     this.serviceCreator = serviceCreator;
/* 244 */     if (serviceController != null)
/* 245 */       this.serviceBinding = serviceController.getServiceBinding();
/*     */   }
/*     */ 
/*     */   public void setServiceBinding(ServiceBinding serviceBinding)
/*     */   {
/* 256 */     this.serviceBinding = serviceBinding;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public List<ObjectName> install(Element config, ObjectName loaderName)
/*     */     throws DeploymentException
/*     */   {
/* 274 */     ServiceMetaDataParser parser = new ServiceMetaDataParser(config);
/* 275 */     List metaDatas = parser.parse();
/*     */ 
/* 278 */     List result = new ArrayList(metaDatas.size());
/*     */ 
/* 281 */     for (ServiceMetaData metaData : metaDatas)
/*     */     {
/* 283 */       ObjectName objectName = metaData.getObjectName();
/* 284 */       Collection attrs = metaData.getAttributes();
/*     */       try
/*     */       {
/* 288 */         ServiceCreator.install(this.server, objectName, metaData, null);
/* 289 */         result.add(objectName);
/* 290 */         configure(this.server, null, objectName, loaderName, attrs);
/* 291 */         if (this.serviceBinding != null) {
/* 292 */           applyServiceConfig(this.server, objectName, this.serviceBinding);
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 297 */         for (ObjectName name : result)
/*     */         {
/*     */           try
/*     */           {
/* 301 */             this.serviceCreator.remove(name);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 305 */             log.error("Error removing mbean after failed deployment: " + name, e);
/*     */           }
/*     */         }
/* 308 */         DeploymentException.rethrowAsDeploymentException("Error during install", t);
/*     */       }
/*     */     }
/* 311 */     return result;
/*     */   }
/*     */ 
/*     */   public static String getConfiguration(MBeanServer server, ServiceController serviceController, ObjectName[] objectNames)
/*     */     throws Exception
/*     */   {
/* 327 */     Writer out = new StringWriter();
/*     */ 
/* 329 */     DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/* 330 */     DocumentBuilder builder = factory.newDocumentBuilder();
/* 331 */     Document doc = builder.newDocument();
/*     */ 
/* 333 */     Element serverElement = doc.createElement("server");
/*     */ 
/* 336 */     for (int j = 0; j < objectNames.length; j++)
/*     */     {
/* 338 */       Element mbeanElement = internalGetConfiguration(doc, server, serviceController, objectNames[j]);
/* 339 */       serverElement.appendChild(mbeanElement);
/*     */     }
/*     */ 
/* 342 */     doc.appendChild(serverElement);
/*     */ 
/* 345 */     new DOMWriter(out).setPrettyprint(true).print(doc);
/*     */ 
/* 347 */     out.close();
/*     */ 
/* 350 */     return out.toString();
/*     */   }
/*     */ 
/*     */   private static Element internalGetConfiguration(Document doc, MBeanServer server, ServiceController serviceController, ObjectName name) throws Exception
/*     */   {
/* 355 */     Element mbeanElement = doc.createElement("mbean");
/* 356 */     mbeanElement.setAttribute("name", name.toString());
/*     */ 
/* 358 */     MBeanInfo info = server.getMBeanInfo(name);
/* 359 */     mbeanElement.setAttribute("code", info.getClassName());
/* 360 */     MBeanAttributeInfo[] attributes = info.getAttributes();
/* 361 */     boolean trace = log.isTraceEnabled();
/* 362 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/* 364 */       if (trace)
/* 365 */         log.trace("considering attribute: " + attributes[i]);
/* 366 */       if ((!attributes[i].isReadable()) || (!attributes[i].isWritable()))
/*     */         continue;
/* 368 */       Element attributeElement = null;
/* 369 */       if (attributes[i].getType().equals("javax.management.ObjectName"))
/*     */       {
/* 371 */         attributeElement = doc.createElement("depends");
/* 372 */         attributeElement.setAttribute("optional-attribute-name", attributes[i].getName());
/*     */       }
/*     */       else
/*     */       {
/* 376 */         attributeElement = doc.createElement("attribute");
/* 377 */         attributeElement.setAttribute("name", attributes[i].getName());
/*     */       }
/* 379 */       Object value = server.getAttribute(name, attributes[i].getName());
/*     */ 
/* 381 */       if (value != null)
/*     */       {
/* 383 */         if ((value instanceof Element))
/*     */         {
/* 385 */           attributeElement.appendChild(doc.importNode((Element)value, true));
/*     */         }
/*     */         else
/*     */         {
/* 389 */           attributeElement.appendChild(doc.createTextNode(value.toString()));
/*     */         }
/*     */       }
/* 392 */       mbeanElement.appendChild(attributeElement);
/*     */     }
/*     */ 
/* 396 */     ServiceContext sc = serviceController.getServiceContext(name);
/* 397 */     for (Iterator i = sc.iDependOn.iterator(); i.hasNext(); )
/*     */     {
/* 399 */       ServiceContext needs = (ServiceContext)i.next();
/* 400 */       Element dependsElement = doc.createElement("depends");
/* 401 */       dependsElement.appendChild(doc.createTextNode(needs.objectName.toString()));
/* 402 */       mbeanElement.appendChild(dependsElement);
/*     */     }
/*     */ 
/* 405 */     return mbeanElement;
/*     */   }
/*     */ 
/*     */   public String getConfiguration(ObjectName[] objectNames)
/*     */     throws Exception
/*     */   {
/* 419 */     return getConfiguration(this.server, this.serviceController, objectNames);
/*     */   }
/*     */ 
/*     */   public static StringBuffer getElementContent(Element element)
/*     */     throws IOException, TransformerException
/*     */   {
/* 436 */     NodeList children = element.getChildNodes();
/* 437 */     Element content = null;
/* 438 */     for (int n = 0; n < children.getLength(); n++)
/*     */     {
/* 440 */       Node node = children.item(n);
/* 441 */       if (node.getNodeType() != 1)
/*     */         continue;
/* 443 */       content = (Element)node;
/* 444 */       break;
/*     */     }
/*     */ 
/* 447 */     if (content == null) {
/* 448 */       return null;
/*     */     }
/*     */ 
/* 451 */     DOMSource source = new DOMSource(content);
/* 452 */     TransformerFactory tFactory = TransformerFactory.newInstance();
/* 453 */     Transformer transformer = tFactory.newTransformer();
/* 454 */     StringWriter sw = new StringWriter();
/* 455 */     StreamResult result = new StreamResult(sw);
/* 456 */     transformer.transform(source, result);
/* 457 */     sw.close();
/* 458 */     return sw.getBuffer();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.ServiceConfigurator
 * JD-Core Version:    0.6.0
 */