/*    */ package org.jboss.system;
/*    */ 
/*    */ import java.util.Map;
/*    */ import java.util.concurrent.ConcurrentHashMap;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class Registry
/*    */ {
/* 41 */   private static final Logger log = Logger.getLogger(Registry.class);
/*    */ 
/* 43 */   public static Map<Object, Object> entries = new ConcurrentHashMap();
/*    */ 
/*    */   public static void bind(Object key, Object value)
/*    */   {
/* 47 */     entries.put(key, value);
/* 48 */     if (log.isTraceEnabled())
/* 49 */       log.trace("bound " + key + "=" + value);
/*    */   }
/*    */ 
/*    */   public static Object unbind(Object key)
/*    */   {
/* 54 */     Object obj = entries.remove(key);
/* 55 */     if (log.isTraceEnabled())
/* 56 */       log.trace("unbound " + key + "=" + obj);
/* 57 */     return obj;
/*    */   }
/*    */ 
/*    */   public static Object lookup(Object key)
/*    */   {
/* 62 */     Object obj = entries.get(key);
/* 63 */     if (log.isTraceEnabled())
/* 64 */       log.trace("lookup " + key + "=" + obj);
/* 65 */     return obj;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.Registry
 * JD-Core Version:    0.6.0
 */