/*     */ package org.jboss.system;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerNotification;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationFilterSupport;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public abstract class ListenerServiceMBeanSupport extends ServiceMBeanSupport
/*     */   implements ListenerServiceMBean, NotificationListener
/*     */ {
/*     */   private List sublist;
/*     */   private Element xmllist;
/*     */   private boolean dynamicSubscriptions;
/*     */   private ObjectName listener;
/*     */   private Object myHandback;
/*     */   private NotificationFilterSupport myFilter;
/*     */   private boolean subscribed;
/*     */ 
/*     */   public ListenerServiceMBeanSupport()
/*     */   {
/* 143 */     init();
/*     */   }
/*     */ 
/*     */   public ListenerServiceMBeanSupport(Class type)
/*     */   {
/* 155 */     super(type);
/* 156 */     init();
/*     */   }
/*     */ 
/*     */   public ListenerServiceMBeanSupport(String category)
/*     */   {
/* 168 */     super(category);
/* 169 */     init();
/*     */   }
/*     */ 
/*     */   public ListenerServiceMBeanSupport(Logger log)
/*     */   {
/* 181 */     super(log);
/* 182 */     init();
/*     */   }
/*     */ 
/*     */   public void setSubscriptionList(Element list)
/*     */   {
/* 198 */     this.xmllist = ((Element)list.cloneNode(true));
/*     */   }
/*     */ 
/*     */   public List<SubscriptionInfo> getSubscriptions()
/*     */   {
/* 205 */     return this.sublist;
/*     */   }
/*     */ 
/*     */   public void setSubscriptions(List<SubscriptionInfo> list)
/*     */   {
/* 210 */     this.sublist = list;
/*     */   }
/*     */ 
/*     */   public void subscribe(boolean dynamicSubscriptions)
/*     */     throws Exception
/*     */   {
/* 222 */     subscribe(dynamicSubscriptions, getServiceName());
/*     */   }
/*     */ 
/*     */   public void subscribe(boolean dynamicSubscriptions, ObjectName listener)
/*     */     throws Exception
/*     */   {
/* 236 */     if ((this.xmllist != null) && (this.sublist == null))
/*     */     {
/* 239 */       this.log.debug("Parsing subscription specification");
/* 240 */       List subscriptionList = parseXMLSubscriptionSpec(this.xmllist);
/*     */ 
/* 242 */       subscribe(subscriptionList, dynamicSubscriptions, listener);
/*     */     }
/* 244 */     else if (this.sublist != null)
/*     */     {
/* 246 */       subscribe(this.sublist, dynamicSubscriptions, listener);
/*     */     }
/*     */     else {
/* 249 */       this.log.debug("Subscription specification not provided");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void subscribe(List subscriptionList, boolean dynamicSubscriptions, ObjectName listener)
/*     */     throws Exception
/*     */   {
/* 264 */     if (this.subscribed) {
/* 265 */       return;
/*     */     }
/*     */ 
/* 268 */     if (subscriptionList != null)
/*     */     {
/* 271 */       this.sublist = subscriptionList;
/* 272 */       this.dynamicSubscriptions = dynamicSubscriptions;
/* 273 */       this.listener = listener;
/*     */ 
/* 275 */       this.log.debug(this.sublist);
/*     */ 
/* 277 */       this.log.debug("Subscribing for JMX notifications, dynamic=" + dynamicSubscriptions + (getServiceName().equals(listener) ? "" : new StringBuilder().append(", listener='").append(listener).append("'").toString()));
/*     */ 
/* 282 */       bulkRegister();
/*     */ 
/* 284 */       if (dynamicSubscriptions == true)
/*     */       {
/* 287 */         getServer().addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), getServiceName(), this.myFilter, this.myHandback);
/*     */ 
/* 294 */         this.log.debug("Subscribed to MBeanServerDelegate, too");
/*     */       }
/*     */ 
/* 297 */       this.subscribed = true;
/*     */     }
/*     */     else {
/* 300 */       this.log.debug("Subscription list not provided");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unsubscribe()
/*     */   {
/* 309 */     if (!this.subscribed) {
/* 310 */       return;
/*     */     }
/* 312 */     this.log.debug("Removing all JMX notification subscriptions");
/* 313 */     bulkUnregister();
/*     */ 
/* 315 */     if (this.dynamicSubscriptions == true)
/*     */     {
/*     */       try
/*     */       {
/* 319 */         getServer().removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), getServiceName(), this.myFilter, this.myHandback);
/*     */ 
/* 326 */         this.log.debug("Unsubscribed from MBeanServerDelegate, too");
/*     */       }
/*     */       catch (MalformedObjectNameException e)
/*     */       {
/* 331 */         this.log.warn("Could not convert 'JMImplementation:type=MBeanServerDelegate' to ObjectName", e);
/*     */       }
/*     */       catch (InstanceNotFoundException e)
/*     */       {
/* 337 */         this.log.warn("Could not unsubscribe from non-existent MBeanServerDelegate!", e);
/*     */       }
/*     */       catch (ListenerNotFoundException e)
/*     */       {
/* 342 */         this.log.warn("Could not unsubscribe from MBeanServerDelegate", e);
/*     */       }
/*     */     }
/*     */ 
/* 346 */     this.subscribed = false;
/*     */   }
/*     */ 
/*     */   public void handleNotification(Notification notification, Object handback)
/*     */   {
/* 360 */     if ((this.dynamicSubscriptions == true) && (handback == this.myHandback))
/*     */     {
/* 362 */       if (this.log.isTraceEnabled()) {
/* 363 */         this.log.trace("It's for me: " + notification + ", handback:" + handback);
/*     */       }
/* 365 */       String type = notification.getType();
/* 366 */       ObjectName target = null;
/*     */       try {
/* 368 */         target = ((MBeanServerNotification)notification).getMBeanName();
/*     */       }
/*     */       catch (ClassCastException e) {
/* 371 */         this.log.warn("MBeanServer sent unknown notification class type: " + notification.getClass().getName());
/*     */ 
/* 373 */         return;
/*     */       }
/*     */ 
/* 376 */       if (type.equals("JMX.mbean.registered"))
/*     */       {
/* 379 */         Iterator i = this.sublist.iterator();
/*     */ 
/* 381 */         while (i.hasNext())
/*     */         {
/* 383 */           SubscriptionInfo mbeanInfo = (SubscriptionInfo)i.next();
/*     */ 
/* 385 */           ObjectName objectName = mbeanInfo.getObjectName();
/*     */           try
/*     */           {
/* 389 */             if (objectName.apply(target))
/*     */             {
/* 391 */               this.log.debug("ObjectName: '" + target + "' matched '" + objectName + "'");
/*     */ 
/* 394 */               singleRegister(getServer(), target, this.listener, mbeanInfo.getFilter(), mbeanInfo.getHandback());
/*     */             }
/*     */ 
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 407 */             this.log.warn("Caught exception from ObjectName.apply(" + target + ")", e);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 414 */         this.log.warn("Got unknown notification type from MBeanServerDelegate: " + type);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 419 */       handleNotification2(notification, handback);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleNotification2(Notification notification, Object handback)
/*     */   {
/*     */   }
/*     */ 
/*     */   private void init()
/*     */   {
/* 438 */     this.myHandback = new Integer(2147483647);
/*     */ 
/* 441 */     this.myFilter = new NotificationFilterSupport();
/* 442 */     this.myFilter.enableType("JMX.mbean.registered");
/*     */   }
/*     */ 
/*     */   private void singleRegister(MBeanServer server, ObjectName target, ObjectName listener, NotificationFilter filter, Object handback)
/*     */   {
/*     */     try
/*     */     {
/* 454 */       server.addNotificationListener(target, listener, filter, handback);
/*     */ 
/* 456 */       logSubscription(target, listener, handback, filter);
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 461 */       this.log.debug("Could not subscribe to: '" + target + "', target or listener MBean not registered");
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 466 */       this.log.warn("Failed to subscribe to: '" + target + "', maybe not a notification broadcaster or: '" + listener + "', maybe not a notification listener");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void singleUnregister(MBeanServer server, ObjectName target, ObjectName listener, NotificationFilter filter, Object handback)
/*     */   {
/*     */     try
/*     */     {
/* 482 */       server.removeNotificationListener(target, listener, filter, handback);
/*     */ 
/* 484 */       this.log.debug("Unsubscribed from: '" + target + "'");
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 489 */       this.log.debug("Could not unsubscribe from non-existent: '" + target + "'");
/*     */     }
/*     */     catch (ListenerNotFoundException e)
/*     */     {
/* 496 */       this.log.debug("Could not unsubscribe from: '" + target + "'");
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 501 */       this.log.debug("Could not unsubscribe from: '" + target + "'");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void bulkRegister()
/*     */   {
/* 511 */     Iterator i = this.sublist.iterator();
/*     */ 
/* 514 */     MBeanServer server = getServer();
/*     */ 
/* 516 */     while (i.hasNext())
/*     */     {
/* 518 */       SubscriptionInfo mbeanInfo = (SubscriptionInfo)i.next();
/*     */ 
/* 520 */       ObjectName objectName = mbeanInfo.getObjectName();
/* 521 */       Object handback = mbeanInfo.getHandback();
/* 522 */       NotificationFilter filter = mbeanInfo.getFilter();
/*     */ 
/* 524 */       if (objectName.isPattern())
/*     */       {
/* 526 */         Set mset = server.queryNames(objectName, null);
/*     */ 
/* 528 */         this.log.debug("ObjectName: '" + objectName + "' matched " + mset.size() + " MBean(s)");
/*     */ 
/* 530 */         Iterator j = mset.iterator();
/* 531 */         while (j.hasNext())
/* 532 */           singleRegister(server, (ObjectName)j.next(), this.listener, filter, handback);
/*     */       }
/*     */       else
/*     */       {
/* 536 */         singleRegister(server, objectName, this.listener, filter, handback);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void bulkUnregister()
/*     */   {
/* 546 */     Iterator i = this.sublist.iterator();
/*     */ 
/* 549 */     MBeanServer server = getServer();
/*     */ 
/* 551 */     while (i.hasNext())
/*     */     {
/* 553 */       SubscriptionInfo mbeanInfo = (SubscriptionInfo)i.next();
/*     */ 
/* 555 */       ObjectName objectName = mbeanInfo.getObjectName();
/* 556 */       Object handback = mbeanInfo.getHandback();
/* 557 */       NotificationFilter filter = mbeanInfo.getFilter();
/*     */ 
/* 559 */       if (objectName.isPattern())
/*     */       {
/* 561 */         Set mset = server.queryNames(objectName, null);
/*     */ 
/* 563 */         this.log.debug("ObjectName: '" + objectName + "' matched " + mset.size() + " MBean(s)");
/*     */ 
/* 565 */         Iterator j = mset.iterator();
/* 566 */         while (j.hasNext())
/* 567 */           singleUnregister(server, (ObjectName)j.next(), this.listener, filter, handback);
/*     */       }
/*     */       else
/*     */       {
/* 571 */         singleUnregister(server, objectName, this.listener, filter, handback);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void logSubscription(ObjectName objectName, ObjectName listener, Object handback, NotificationFilter filter)
/*     */   {
/* 582 */     StringBuffer sbuf = new StringBuffer(100);
/*     */ 
/* 584 */     sbuf.append("Subscribed to: { objectName='").append(objectName);
/* 585 */     sbuf.append("', listener='").append(listener);
/* 586 */     sbuf.append("', handback=").append(handback);
/* 587 */     sbuf.append(", filter=");
/* 588 */     sbuf.append(filter == null ? null : filter.toString());
/* 589 */     sbuf.append(" }");
/*     */ 
/* 591 */     this.log.debug(sbuf.toString());
/*     */   }
/*     */ 
/*     */   private NotificationFilter createNotificationFilter(String factoryClass, Element filterConfig)
/*     */     throws Exception
/*     */   {
/*     */     NotificationFilterFactory factory;
/*     */     try
/*     */     {
/* 604 */       Class clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
/* 605 */       factory = (NotificationFilterFactory)clazz.newInstance();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/* 615 */         factoryClass = "org.jboss.system.filterfactory." + factoryClass;
/* 616 */         Class clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
/* 617 */         factory = (NotificationFilterFactory)clazz.newInstance();
/*     */       }
/*     */       catch (Exception inner)
/*     */       {
/* 621 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/* 625 */     return factory.createNotificationFilter(filterConfig);
/*     */   }
/*     */ 
/*     */   private ArrayList parseXMLSubscriptionSpec(Element root)
/*     */     throws Exception
/*     */   {
/* 634 */     ArrayList slist = new ArrayList();
/*     */ 
/* 637 */     if (!root.getNodeName().equals("subscription-list"))
/*     */     {
/* 639 */       throw new Exception("Expected 'subscription-list' element, got: '" + root.getNodeName() + "'");
/*     */     }
/*     */ 
/* 644 */     NodeList rootlist = root.getChildNodes();
/*     */ 
/* 646 */     for (int i = 0; i < rootlist.getLength(); i++)
/*     */     {
/* 649 */       Node mbean = rootlist.item(i);
/*     */ 
/* 651 */       if (!mbean.getNodeName().equals("mbean")) {
/*     */         continue;
/*     */       }
/* 654 */       String name = null;
/*     */ 
/* 656 */       if (((Element)mbean).hasAttribute("name"))
/*     */       {
/* 658 */         name = ((Element)mbean).getAttribute("name");
/*     */       }
/*     */       else
/*     */       {
/* 662 */         throw new Exception("'mbean' element must have a 'name' attribute");
/*     */       }
/*     */ 
/* 666 */       String handback = null;
/* 667 */       if (((Element)mbean).hasAttribute("handback"))
/*     */       {
/* 669 */         handback = ((Element)mbean).getAttribute("handback");
/*     */       }
/*     */ 
/* 674 */       ObjectName objectName = new ObjectName(name);
/*     */ 
/* 677 */       NotificationFilter filter = null;
/*     */ 
/* 679 */       NodeList mbeanChildren = mbean.getChildNodes();
/*     */ 
/* 682 */       for (int j = 0; j < mbeanChildren.getLength(); j++)
/*     */       {
/* 684 */         Node mbeanChildNode = mbeanChildren.item(j);
/*     */ 
/* 687 */         if (!mbeanChildNode.getNodeName().equals("filter")) {
/*     */           continue;
/*     */         }
/* 690 */         String factory = null;
/* 691 */         if (((Element)mbeanChildNode).hasAttribute("factory"))
/*     */         {
/* 693 */           factory = ((Element)mbeanChildNode).getAttribute("factory");
/*     */ 
/* 696 */           filter = createNotificationFilter(factory, (Element)mbeanChildNode);
/* 697 */           break;
/*     */         }
/*     */ 
/* 701 */         throw new Exception("'filter' element must have a 'factory' attribute");
/*     */       }
/*     */ 
/* 707 */       if (filter == null)
/*     */       {
/* 715 */         ArrayList tmplist = new ArrayList(mbeanChildren.getLength());
/*     */ 
/* 717 */         for (int j = 0; j < mbeanChildren.getLength(); j++)
/*     */         {
/* 719 */           Node mbeanChildNode = mbeanChildren.item(j);
/*     */ 
/* 722 */           if (!mbeanChildNode.getNodeName().equals("notification")) {
/*     */             continue;
/*     */           }
/* 725 */           String type = null;
/* 726 */           if (((Element)mbeanChildNode).hasAttribute("type"))
/*     */           {
/* 728 */             type = ((Element)mbeanChildNode).getAttribute("type");
/* 729 */             tmplist.add(type);
/*     */           }
/*     */           else
/*     */           {
/* 733 */             throw new Exception("'notification' element must have a 'type' attribute");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 739 */         if (tmplist.size() > 0)
/*     */         {
/* 741 */           NotificationFilterSupport sfilter = new NotificationFilterSupport();
/* 742 */           for (int j = 0; j < tmplist.size(); j++)
/*     */           {
/* 744 */             sfilter.enableType((String)tmplist.get(j));
/*     */           }
/* 746 */           filter = sfilter;
/*     */         }
/*     */       }
/* 749 */       slist.add(new SubscriptionInfo(objectName, handback, filter));
/*     */     }
/*     */ 
/* 753 */     return slist;
/*     */   }
/*     */ 
/*     */   public static final class SubscriptionInfo
/*     */   {
/*     */     private ObjectName objectName;
/*     */     private Object handback;
/*     */     private NotificationFilter filter;
/*     */ 
/*     */     public SubscriptionInfo(ObjectName objectName, Object handback, NotificationFilter filter)
/*     */     {
/* 781 */       this.objectName = objectName;
/* 782 */       this.handback = handback;
/* 783 */       this.filter = filter;
/*     */     }
/*     */ 
/*     */     public ObjectName getObjectName()
/*     */     {
/* 792 */       return this.objectName;
/*     */     }
/*     */ 
/*     */     public Object getHandback()
/*     */     {
/* 800 */       return this.handback;
/*     */     }
/*     */ 
/*     */     public NotificationFilter getFilter()
/*     */     {
/* 808 */       return this.filter;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 816 */       StringBuffer sbuf = new StringBuffer(100);
/*     */ 
/* 818 */       sbuf.append("SubscriptionInfo { objectName='").append(this.objectName);
/* 819 */       sbuf.append("', handback=").append(this.handback);
/* 820 */       sbuf.append(", filter=");
/* 821 */       sbuf.append(this.filter == null ? null : this.filter.toString());
/*     */ 
/* 823 */       sbuf.append(" }");
/*     */ 
/* 825 */       return sbuf.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.ListenerServiceMBeanSupport
 * JD-Core Version:    0.6.0
 */