/*     */ package org.jboss.system;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.Notification;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class BarrierController extends ListenerServiceMBeanSupport
/*     */   implements BarrierControllerMBean
/*     */ {
/*     */   private ObjectName barrierName;
/*     */   private Boolean enableOnStartup;
/*     */   private String startHandback;
/*     */   private String stopHandback;
/*     */   private Boolean dynamicSubscriptions;
/*     */   protected Barrier barrier;
/*     */ 
/*     */   public String getBarrierStateString()
/*     */   {
/*  99 */     return this.barrier != null ? this.barrier.getStateString() : null;
/*     */   }
/*     */ 
/*     */   public void setBarrierObjectName(ObjectName barrierName)
/*     */   {
/* 110 */     if (this.barrierName == null)
/*     */     {
/* 112 */       this.barrierName = barrierName;
/*     */     }
/*     */   }
/*     */ 
/*     */   public ObjectName getBarrierObjectName()
/*     */   {
/* 123 */     return this.barrierName;
/*     */   }
/*     */ 
/*     */   public void setBarrierEnabledOnStartup(Boolean enableOnStartup)
/*     */   {
/* 138 */     if (this.enableOnStartup == null)
/*     */     {
/* 140 */       this.enableOnStartup = enableOnStartup;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Boolean getBarrierEnabledOnStartup()
/*     */   {
/* 155 */     if (this.enableOnStartup == null)
/*     */     {
/* 159 */       this.enableOnStartup = enableOnStartup();
/*     */     }
/* 161 */     return this.enableOnStartup;
/*     */   }
/*     */ 
/*     */   public void setStartBarrierHandback(String startHandback)
/*     */   {
/* 172 */     if (this.startHandback == null)
/*     */     {
/* 174 */       this.startHandback = startHandback;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getStartBarrierHandback()
/*     */   {
/* 185 */     return this.startHandback;
/*     */   }
/*     */ 
/*     */   public void setStopBarrierHandback(String stopHandback)
/*     */   {
/* 196 */     if (this.stopHandback == null)
/*     */     {
/* 198 */       this.stopHandback = stopHandback;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getStopBarrierHandback()
/*     */   {
/* 209 */     return this.stopHandback;
/*     */   }
/*     */ 
/*     */   public void setDynamicSubscriptions(Boolean dynamicSubscriptions)
/*     */   {
/* 220 */     if (this.dynamicSubscriptions == null)
/*     */     {
/* 222 */       this.dynamicSubscriptions = dynamicSubscriptions;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Boolean getDynamicSubscriptions()
/*     */   {
/* 233 */     if (this.dynamicSubscriptions == null)
/*     */     {
/* 235 */       this.dynamicSubscriptions = Boolean.TRUE;
/*     */     }
/* 237 */     return this.dynamicSubscriptions;
/*     */   }
/*     */ 
/*     */   protected Boolean enableOnStartup()
/*     */   {
/* 253 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 261 */     this.barrier = new Barrier(getServiceName());
/*     */ 
/* 263 */     initBarrier();
/*     */   }
/*     */ 
/*     */   private void initBarrier()
/*     */     throws Exception
/*     */   {
/* 275 */     if ((this.barrier != null) && (getServer() != null))
/*     */     {
/* 278 */       getServer().registerMBean(this.barrier, this.barrierName);
/*     */ 
/* 281 */       this.barrier.create();
/*     */ 
/* 284 */       if (getBarrierEnabledOnStartup().booleanValue())
/*     */       {
/* 286 */         startBarrier();
/*     */       }
/*     */ 
/* 289 */       subscribe(getDynamicSubscriptions().booleanValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */   {
/* 296 */     unsubscribe();
/*     */     try
/*     */     {
/* 301 */       this.barrier.destroy();
/*     */ 
/* 304 */       getServer().unregisterMBean(this.barrierName);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 308 */       this.log.debug("Unexpected error during destroy", e);
/*     */     }
/*     */ 
/* 312 */     this.barrier = null;
/*     */   }
/*     */ 
/*     */   public void handleNotification2(Notification n, Object handback)
/*     */   {
/* 323 */     this.log.debug("Got notification: " + n);
/*     */ 
/* 325 */     if ((this.startHandback != null) && (this.startHandback.equals(handback)))
/*     */     {
/* 327 */       this.log.debug("Saw '" + handback + "' handback, starting barrier");
/* 328 */       startBarrier();
/*     */     }
/* 330 */     else if ((this.stopHandback != null) && (this.stopHandback.equals(handback)))
/*     */     {
/* 332 */       this.log.debug("Saw '" + handback + "' handback, stopping barrier");
/* 333 */       stopBarrier();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void startBarrier()
/*     */   {
/*     */     try
/*     */     {
/* 349 */       this.barrier.start();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 353 */       this.log.warn("Failed to start barrier: " + this.barrierName, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stopBarrier()
/*     */   {
/*     */     try
/*     */     {
/* 367 */       this.barrier.stop();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 371 */       this.log.warn("Failed to stop barrier: " + this.barrierName, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/* 380 */     super.postRegister(registrationDone);
/*     */ 
/* 382 */     if (Boolean.TRUE.equals(registrationDone))
/*     */     {
/*     */       try
/*     */       {
/* 386 */         initBarrier();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 390 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Barrier extends ServiceMBeanSupport
/*     */     implements BarrierController.BarrierMBean
/*     */   {
/*     */     private ObjectName barrierController;
/*     */ 
/*     */     public Barrier(ObjectName barrierController)
/*     */     {
/* 422 */       this.barrierController = barrierController;
/*     */     }
/*     */ 
/*     */     public ObjectName getBarrierController()
/*     */     {
/* 428 */       return this.barrierController;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface BarrierMBean
/*     */   {
/*     */     public abstract ObjectName getBarrierController();
/*     */ 
/*     */     public abstract String getStateString();
/*     */ 
/*     */     public abstract int getState();
/*     */ 
/*     */     public abstract void jbossInternalLifecycle(String paramString)
/*     */       throws Exception;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.system.BarrierController
 * JD-Core Version:    0.6.0
 */