/*     */ package org.jboss.serial.util;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public final class FastHashMap
/*     */   implements Map, Serializable
/*     */ {
/* 144 */   private HashMap map = null;
/*     */ 
/*     */   public FastHashMap()
/*     */   {
/*  98 */     this.map = new HashMap();
/*     */   }
/*     */ 
/*     */   public FastHashMap(int capacity)
/*     */   {
/* 110 */     this.map = new HashMap(capacity);
/*     */   }
/*     */ 
/*     */   public FastHashMap(int capacity, float factor)
/*     */   {
/* 123 */     this.map = new HashMap(capacity, factor);
/*     */   }
/*     */ 
/*     */   public FastHashMap(Map map)
/*     */   {
/* 135 */     this.map = new HashMap(map);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 153 */     synchronized (this) {
/* 154 */       HashMap temp = (HashMap)this.map.clone();
/* 155 */       temp.clear();
/* 156 */       this.map = temp;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 167 */     return new FastHashMap(this.map);
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 179 */     return this.map.containsKey(key);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object value)
/*     */   {
/* 191 */     return this.map.containsValue(value);
/*     */   }
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/* 201 */     return this.map.entrySet();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 216 */     if (o == this)
/* 217 */       return true;
/* 218 */     if (!(o instanceof Serializable))
/* 219 */       return false;
/* 220 */     Map mo = (Serializable)o;
/*     */ 
/* 224 */     if (mo.size() != this.map.size())
/* 225 */       return false;
/* 226 */     Iterator i = this.map.entrySet().iterator();
/* 227 */     while (i.hasNext()) {
/* 228 */       Map.Entry e = (Map.Entry)i.next();
/* 229 */       Object key = e.getKey();
/* 230 */       Object value = e.getValue();
/* 231 */       if (value == null) {
/* 232 */         if ((mo.get(key) != null) || (!mo.containsKey(key))) {
/* 233 */           return false;
/*     */         }
/*     */       }
/* 236 */       else if (!value.equals(mo.get(key))) {
/* 237 */         return false;
/*     */       }
/*     */     }
/* 240 */     return true;
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 254 */     return this.map.get(key);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 265 */     int h = 0;
/* 266 */     Iterator i = this.map.entrySet().iterator();
/* 267 */     while (i.hasNext())
/* 268 */       h += i.next().hashCode();
/* 269 */     return h;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 278 */     return this.map.isEmpty();
/*     */   }
/*     */ 
/*     */   public Set keySet()
/*     */   {
/* 287 */     return this.map.keySet();
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/* 301 */     synchronized (this) {
/* 302 */       HashMap temp = (HashMap)this.map.clone();
/* 303 */       Object result = temp.put(key, value);
/* 304 */       this.map = temp;
/* 305 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void putAll(Map in)
/*     */   {
/* 318 */     synchronized (this) {
/* 319 */       HashMap temp = (HashMap)this.map.clone();
/* 320 */       temp.putAll(in);
/* 321 */       this.map = temp;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/* 334 */     synchronized (this) {
/* 335 */       HashMap temp = (HashMap)this.map.clone();
/* 336 */       Object result = temp.remove(key);
/* 337 */       this.map = temp;
/* 338 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 348 */     return this.map.size();
/*     */   }
/*     */ 
/*     */   public Collection values()
/*     */   {
/* 357 */     return this.map.values();
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 361 */     return this.map.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.util.FastHashMap
 * JD-Core Version:    0.6.0
 */