/*    */ package org.jboss.serial.persister;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import java.lang.reflect.Proxy;
/*    */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*    */ import org.jboss.serial.classmetamodel.StreamingClass;
/*    */ import org.jboss.serial.exception.SerializationException;
/*    */ import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
/*    */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*    */ 
/*    */ public class ProxyPersister
/*    */   implements Persister
/*    */ {
/*    */   private byte id;
/*    */ 
/*    */   public byte getId()
/*    */   {
/* 48 */     return this.id;
/*    */   }
/*    */ 
/*    */   public void setId(byte id) {
/* 52 */     this.id = id;
/*    */   }
/*    */ 
/*    */   public void writeData(ClassMetaData metaData, ObjectOutput output, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
/* 56 */     Object handler = Proxy.getInvocationHandler(obj);
/*    */ 
/* 58 */     output.writeObject(handler);
/* 59 */     output.writeObject(obj.getClass());
/*    */   }
/*    */ 
/*    */   public Object readData(ClassLoader loader, StreamingClass streaming, ClassMetaData metaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException
/*    */   {
/*    */     try
/*    */     {
/* 66 */       Object handler = input.readObject();
/* 67 */       Class proxy = (Class)input.readObject();
/* 68 */       Constructor constructor = proxy.getConstructor(new Class[] { InvocationHandler.class });
/* 69 */       Object obj = constructor.newInstance(new Object[] { handler });
/* 70 */       cache.putObjectInCacheRead(referenceId, obj);
/* 71 */       return obj;
/*    */     }
/*    */     catch (ClassNotFoundException e)
/*    */     {
/* 75 */       throw new SerializationException(e);
/*    */     }
/*    */     catch (NoSuchMethodException e)
/*    */     {
/* 79 */       throw new SerializationException(e);
/*    */     }
/*    */     catch (IllegalAccessException e)
/*    */     {
/* 83 */       throw new SerializationException(e);
/*    */     }
/*    */     catch (InstantiationException e)
/*    */     {
/* 87 */       throw new SerializationException(e);
/*    */     }
/*    */     catch (InvocationTargetException e) {
/*    */     }
/* 91 */     throw new SerializationException(e);
/*    */   }
/*    */ 
/*    */   public boolean canPersist(Object obj)
/*    */   {
/* 98 */     return false;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.persister.ProxyPersister
 * JD-Core Version:    0.6.0
 */