/*     */ package org.jboss.serial.persister;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamClass;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaDataSlot;
/*     */ import org.jboss.serial.exception.SerializationException;
/*     */ import org.jboss.serial.objectmetamodel.FieldsContainer;
/*     */ import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
/*     */ 
/*     */ public class ObjectOutputStreamProxy extends ObjectOutputStream
/*     */ {
/*     */   Object currentObj;
/*     */   ClassMetaDataSlot currentMetaClass;
/*     */   ObjectSubstitutionInterface currentSubstitution;
/*  46 */   FieldsContainer currentContainer = null;
/*     */   ObjectOutput bout;
/*     */ 
/*     */   public ObjectOutputStreamProxy(ObjectOutput output, Object currentObj, ClassMetaDataSlot currentMetaClass, ObjectSubstitutionInterface currentSubstitution)
/*     */     throws IOException
/*     */   {
/*  53 */     this.bout = output;
/*  54 */     this.currentObj = currentObj;
/*  55 */     this.currentMetaClass = currentMetaClass;
/*  56 */     this.currentSubstitution = currentSubstitution;
/*     */   }
/*     */ 
/*     */   protected void writeObjectOverride(Object obj) throws IOException {
/*  60 */     this.bout.writeObject(obj);
/*     */   }
/*     */ 
/*     */   public void writeUnshared(Object obj) throws IOException {
/*  64 */     writeObjectOverride(obj);
/*     */   }
/*     */ 
/*     */   public void defaultWriteObject() throws IOException {
/*  68 */     writeFields();
/*     */   }
/*     */ 
/*     */   public void writeFields() throws IOException {
/*  72 */     if (this.currentContainer != null)
/*     */     {
/*  74 */       this.currentContainer.writeMyself(this);
/*  75 */       this.currentContainer = null;
/*     */     }
/*     */     else
/*     */     {
/*  79 */       RegularObjectPersister.writeSlotWithFields(this.currentMetaClass, this.bout, this.currentObj, this.currentSubstitution);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void writeStreamHeader()
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void writeClassDescriptor(ObjectStreamClass desc)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void write(int val)
/*     */     throws IOException
/*     */   {
/* 102 */     this.bout.write(val);
/*     */   }
/*     */ 
/*     */   public void write(byte[] buf)
/*     */     throws IOException
/*     */   {
/* 113 */     this.bout.write(buf);
/*     */   }
/*     */ 
/*     */   public void write(byte[] buf, int off, int len) throws IOException {
/* 117 */     if (buf == null)
/*     */     {
/* 119 */       throw new SerializationException("buf can't be null");
/*     */     }
/* 121 */     this.bout.write(buf, off, len);
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */     throws IOException
/*     */   {
/* 131 */     this.bout.flush();
/*     */   }
/*     */ 
/*     */   protected void drain() throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void close() throws IOException {
/* 139 */     flush();
/* 140 */     this.bout.close();
/*     */   }
/*     */ 
/*     */   public void writeBoolean(boolean val) throws IOException {
/* 144 */     this.bout.writeBoolean(val);
/*     */   }
/*     */ 
/*     */   public void writeByte(int val) throws IOException {
/* 148 */     this.bout.writeByte(val);
/*     */   }
/*     */ 
/*     */   public void writeShort(int val) throws IOException {
/* 152 */     this.bout.writeShort(val);
/*     */   }
/*     */ 
/*     */   public void writeChar(int val) throws IOException {
/* 156 */     this.bout.writeChar(val);
/*     */   }
/*     */ 
/*     */   public void writeInt(int val) throws IOException {
/* 160 */     this.bout.writeInt(val);
/*     */   }
/*     */ 
/*     */   public void writeLong(long val) throws IOException {
/* 164 */     this.bout.writeLong(val);
/*     */   }
/*     */ 
/*     */   public void writeFloat(float val) throws IOException {
/* 168 */     this.bout.writeFloat(val);
/*     */   }
/*     */ 
/*     */   public void writeDouble(double val) throws IOException {
/* 172 */     this.bout.writeDouble(val);
/*     */   }
/*     */ 
/*     */   public void writeBytes(String str) throws IOException {
/* 176 */     this.bout.writeBytes(str);
/*     */   }
/*     */ 
/*     */   public void writeChars(String str) throws IOException {
/* 180 */     this.bout.writeChars(str);
/*     */   }
/*     */ 
/*     */   public void writeUTF(String str) throws IOException {
/* 184 */     this.bout.writeUTF(str);
/*     */   }
/*     */ 
/*     */   public ObjectOutputStream.PutField putFields() throws IOException {
/* 188 */     this.currentContainer = new FieldsContainer(this.currentMetaClass);
/* 189 */     return this.currentContainer.createPut();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.persister.ObjectOutputStreamProxy
 * JD-Core Version:    0.6.0
 */