/*     */ package org.jboss.serial.persister;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InvalidObjectException;
/*     */ import java.io.NotActiveException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectInputValidation;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.io.StreamCorruptedException;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaDataSlot;
/*     */ import org.jboss.serial.objectmetamodel.FieldsContainer;
/*     */ import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
/*     */ 
/*     */ public class ObjectInputStreamProxy extends ObjectInputStream
/*     */ {
/*     */   Object currentObj;
/*     */   ClassMetaDataSlot currentMetaClass;
/*     */   ObjectSubstitutionInterface currentSubstitution;
/*     */   short[] fieldsKey;
/*     */   ObjectInput input;
/*     */ 
/*     */   public ObjectInputStreamProxy(ObjectInput input, short[] fieldsKey, Object currentObj, ClassMetaDataSlot currentMetaClass, ObjectSubstitutionInterface currentSubstitution)
/*     */     throws IOException
/*     */   {
/*  58 */     this.input = input;
/*  59 */     this.fieldsKey = fieldsKey;
/*  60 */     this.currentObj = currentObj;
/*  61 */     this.currentMetaClass = currentMetaClass;
/*  62 */     this.currentSubstitution = currentSubstitution;
/*     */   }
/*     */ 
/*     */   protected Object readObjectOverride()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  68 */     return this.input.readObject();
/*     */   }
/*     */ 
/*     */   public Object readUnshared() throws IOException, ClassNotFoundException
/*     */   {
/*  73 */     return readObjectOverride();
/*     */   }
/*     */ 
/*     */   public void defaultReadObject() throws IOException, ClassNotFoundException
/*     */   {
/*  78 */     RegularObjectPersister.readSlotWithFields(this.fieldsKey, this.currentMetaClass, this.input, this.currentObj);
/*     */   }
/*     */ 
/*     */   public void registerValidation(ObjectInputValidation obj, int prio)
/*     */     throws NotActiveException, InvalidObjectException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void readStreamHeader()
/*     */     throws IOException, StreamCorruptedException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected ObjectStreamClass readClassDescriptor()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  94 */     return null;
/*     */   }
/*     */ 
/*     */   public int read() throws IOException
/*     */   {
/*  99 */     return this.input.read();
/*     */   }
/*     */ 
/*     */   public int read(byte[] buf, int off, int len) throws IOException
/*     */   {
/* 104 */     return this.input.read(buf, off, len);
/*     */   }
/*     */ 
/*     */   public int available()
/*     */     throws IOException
/*     */   {
/* 117 */     return 1;
/*     */   }
/*     */ 
/*     */   public void close() throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean readBoolean() throws IOException
/*     */   {
/* 126 */     return this.input.readBoolean();
/*     */   }
/*     */ 
/*     */   public byte readByte() throws IOException
/*     */   {
/* 131 */     return this.input.readByte();
/*     */   }
/*     */ 
/*     */   public int readUnsignedByte() throws IOException
/*     */   {
/* 136 */     return this.input.readUnsignedByte();
/*     */   }
/*     */ 
/*     */   public char readChar() throws IOException
/*     */   {
/* 141 */     return this.input.readChar();
/*     */   }
/*     */ 
/*     */   public short readShort() throws IOException
/*     */   {
/* 146 */     return this.input.readShort();
/*     */   }
/*     */ 
/*     */   public int readUnsignedShort() throws IOException
/*     */   {
/* 151 */     return this.input.readUnsignedShort();
/*     */   }
/*     */ 
/*     */   public int readInt() throws IOException
/*     */   {
/* 156 */     return this.input.readInt();
/*     */   }
/*     */ 
/*     */   public long readLong() throws IOException
/*     */   {
/* 161 */     return this.input.readLong();
/*     */   }
/*     */ 
/*     */   public float readFloat() throws IOException
/*     */   {
/* 166 */     return this.input.readFloat();
/*     */   }
/*     */ 
/*     */   public double readDouble() throws IOException
/*     */   {
/* 171 */     return this.input.readDouble();
/*     */   }
/*     */ 
/*     */   public void readFully(byte[] buf) throws IOException
/*     */   {
/* 176 */     this.input.readFully(buf);
/*     */   }
/*     */ 
/*     */   public void readFully(byte[] buf, int off, int len) throws IOException
/*     */   {
/* 181 */     this.input.readFully(buf, off, len);
/*     */   }
/*     */ 
/*     */   public int skipBytes(int len) throws IOException
/*     */   {
/* 186 */     return this.input.skipBytes(len);
/*     */   }
/*     */ 
/*     */   public String readLine() throws IOException
/*     */   {
/* 191 */     return this.input.readLine();
/*     */   }
/*     */ 
/*     */   public String readUTF() throws IOException
/*     */   {
/* 196 */     return this.input.readUTF();
/*     */   }
/*     */ 
/*     */   public int read(byte[] b)
/*     */     throws IOException
/*     */   {
/* 206 */     return this.input.read(b);
/*     */   }
/*     */ 
/*     */   public long skip(long n)
/*     */     throws IOException
/*     */   {
/* 216 */     return this.input.skip(n);
/*     */   }
/*     */ 
/*     */   public ObjectInputStream.GetField readFields()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 223 */     FieldsContainer container = new FieldsContainer(this.currentMetaClass);
/* 224 */     container.readMyself(this);
/* 225 */     return container.createGet();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.persister.ObjectInputStreamProxy
 * JD-Core Version:    0.6.0
 */