/*    */ package org.jboss.serial.persister;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*    */ import org.jboss.serial.classmetamodel.StreamingClass;
/*    */ import org.jboss.serial.exception.SerializationException;
/*    */ import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
/*    */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*    */ 
/*    */ public class ExternalizePersister
/*    */   implements Persister
/*    */ {
/*    */   byte id;
/*    */ 
/*    */   public byte getId()
/*    */   {
/* 45 */     return this.id;
/*    */   }
/*    */ 
/*    */   public void setId(byte id) {
/* 49 */     this.id = id;
/*    */   }
/*    */ 
/*    */   public void writeData(ClassMetaData metaData, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution)
/*    */     throws IOException
/*    */   {
/* 58 */     ((Externalizable)obj).writeExternal(out);
/*    */   }
/*    */ 
/*    */   public Object readData(ClassLoader loader, StreamingClass streaming, ClassMetaData metaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution)
/*    */     throws IOException
/*    */   {
/* 67 */     Object obj = metaData.newInstance();
/* 68 */     cache.putObjectInCacheRead(referenceId, obj);
/*    */     try
/*    */     {
/* 72 */       ((Externalizable)obj).readExternal(input);
/*    */     }
/*    */     catch (ClassNotFoundException e) {
/* 75 */       throw new SerializationException(e);
/*    */     }
/*    */ 
/* 78 */     return obj;
/*    */   }
/*    */ 
/*    */   public boolean canPersist(Object obj)
/*    */   {
/* 83 */     return false;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.persister.ExternalizePersister
 * JD-Core Version:    0.6.0
 */