/*     */ package org.jboss.serial.persister;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Proxy;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*     */ import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
/*     */ import org.jboss.serial.classmetamodel.ClassResolver;
/*     */ import org.jboss.serial.classmetamodel.StreamingClass;
/*     */ import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
/*     */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*     */ 
/*     */ public class ClassReferencePersister
/*     */   implements Persister
/*     */ {
/*     */   byte id;
/*     */ 
/*     */   public byte getId()
/*     */   {
/*  46 */     return this.id;
/*     */   }
/*     */ 
/*     */   public void setId(byte id) {
/*  50 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public void writeData(ClassMetaData clazzMetaData, ObjectOutput output, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
/*  54 */     Class clazz = (Class)obj;
/*     */ 
/*  56 */     boolean isProxy = clazzMetaData.isProxy();
/*  57 */     output.writeBoolean(isProxy);
/*     */ 
/*  59 */     if (isProxy)
/*     */     {
/*  61 */       Class[] interfaces = clazz.getInterfaces();
/*  62 */       output.writeInt(interfaces.length);
/*  63 */       for (int i = 0; i < interfaces.length; i++)
/*     */       {
/*  65 */         output.writeUTF(interfaces[i].getName());
/*     */       }
/*     */     }
/*     */     else {
/*  69 */       output.writeUTF(clazz.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object readData(ClassLoader loader, StreamingClass streaming, ClassMetaData metaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException
/*     */   {
/*  75 */     boolean isProxy = input.readBoolean();
/*     */ 
/*  77 */     if (isProxy)
/*     */     {
/*  79 */       int size = input.readInt();
/*  80 */       Class[] interfaces = new Class[size];
/*  81 */       for (int i = 0; i < interfaces.length; i++)
/*     */       {
/*  83 */         interfaces[i] = lookupClass(cache.getClassResolver(), loader, input.readUTF());
/*     */       }
/*     */ 
/*  86 */       Object proxyReturn = Proxy.getProxyClass(loader, interfaces);
/*  87 */       cache.putObjectInCacheRead(referenceId, proxyReturn);
/*  88 */       return proxyReturn;
/*     */     }
/*     */ 
/*  93 */     String name = input.readUTF();
/*  94 */     Class classReturn = lookupClass(cache.getClassResolver(), loader, name);
/*  95 */     cache.putObjectInCacheRead(referenceId, classReturn);
/*  96 */     return classReturn;
/*     */   }
/*     */ 
/*     */   private Class lookupClass(ClassResolver resolver, ClassLoader loader, String name) throws IOException
/*     */   {
/* 101 */     if (name.equals("int"))
/*     */     {
/* 103 */       return Integer.TYPE;
/* 104 */     }if (name.equals("long"))
/*     */     {
/* 106 */       return Long.TYPE;
/* 107 */     }if (name.equals("double"))
/*     */     {
/* 109 */       return Double.TYPE;
/* 110 */     }if (name.equals("float"))
/*     */     {
/* 112 */       return Float.TYPE;
/* 113 */     }if (name.equals("char"))
/*     */     {
/* 115 */       return Character.TYPE;
/* 116 */     }if (name.equals("boolean"))
/*     */     {
/* 118 */       return Boolean.TYPE;
/* 119 */     }if (name.equals("byte"))
/*     */     {
/* 121 */       return Byte.TYPE;
/* 122 */     }if (name.equals("short"))
/*     */     {
/* 124 */       return Short.TYPE;
/*     */     }
/*     */ 
/* 128 */     ClassMetaData metaData = ClassMetamodelFactory.getClassMetaData(name, resolver, loader, false);
/* 129 */     if (metaData.isArray())
/*     */     {
/* 131 */       return metaData.getArrayRepresentation();
/*     */     }
/*     */ 
/* 135 */     return metaData.getClazz();
/*     */   }
/*     */ 
/*     */   public boolean canPersist(Object obj)
/*     */   {
/* 143 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.persister.ClassReferencePersister
 * JD-Core Version:    0.6.0
 */