/*     */ package org.jboss.serial.persister;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Array;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*     */ import org.jboss.serial.classmetamodel.StreamingClass;
/*     */ import org.jboss.serial.exception.SerializationException;
/*     */ import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
/*     */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*     */ 
/*     */ public class ArrayPersister
/*     */   implements Persister
/*     */ {
/*     */   byte id;
/*     */ 
/*     */   public byte getId()
/*     */   {
/*  45 */     return this.id;
/*     */   }
/*     */ 
/*     */   public void setId(byte id) {
/*  49 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public void writeData(ClassMetaData metaData, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution)
/*     */     throws IOException
/*     */   {
/*  60 */     if ((metaData.getArrayDepth() == 1) && (metaData.getClazz().isPrimitive()))
/*     */     {
/*  63 */       Class clazz = metaData.getClazz();
/*  64 */       if (clazz == Integer.TYPE) {
/*  65 */         int[] finalArray = (int[])(int[])obj;
/*  66 */         out.writeInt(finalArray.length);
/*  67 */         for (int i = 0; i < finalArray.length; i++) out.writeInt(finalArray[i]); 
/*     */       }
/*  68 */       else if (clazz == Byte.TYPE) {
/*  69 */         byte[] finalArray = (byte[])(byte[])obj;
/*  70 */         out.writeInt(finalArray.length);
/*  71 */         out.write(finalArray);
/*  72 */       } else if (clazz == Long.TYPE) {
/*  73 */         long[] finalArray = (long[])(long[])obj;
/*  74 */         out.writeInt(finalArray.length);
/*  75 */         for (int i = 0; i < finalArray.length; i++) out.writeLong(finalArray[i]); 
/*     */       }
/*  76 */       else if (clazz == Float.TYPE) {
/*  77 */         float[] finalArray = (float[])(float[])obj;
/*  78 */         out.writeInt(finalArray.length);
/*  79 */         for (int i = 0; i < finalArray.length; i++) out.writeFloat(finalArray[i]); 
/*     */       }
/*  80 */       else if (clazz == Double.TYPE) {
/*  81 */         double[] finalArray = (double[])(double[])obj;
/*  82 */         out.writeInt(finalArray.length);
/*  83 */         for (int i = 0; i < finalArray.length; i++) out.writeDouble(finalArray[i]); 
/*     */       }
/*  84 */       else if (clazz == Short.TYPE) {
/*  85 */         short[] finalArray = (short[])(short[])obj;
/*  86 */         out.writeInt(finalArray.length);
/*  87 */         for (int i = 0; i < finalArray.length; i++) out.writeShort(finalArray[i]); 
/*     */       }
/*  88 */       else if (clazz == Character.TYPE) {
/*  89 */         char[] finalArray = (char[])(char[])obj;
/*  90 */         out.writeInt(finalArray.length);
/*  91 */         for (int i = 0; i < finalArray.length; i++) out.writeChar(finalArray[i]); 
/*     */       }
/*  92 */       else if (clazz == Boolean.TYPE) {
/*  93 */         boolean[] finalArray = (boolean[])(boolean[])obj;
/*  94 */         out.writeInt(finalArray.length);
/*  95 */         for (int i = 0; i < finalArray.length; i++) out.writeBoolean(finalArray[i]); 
/*     */       }
/*     */       else {
/*  97 */         throw new RuntimeException("Unexpected datatype " + clazz.getName());
/*     */       }
/*     */     }
/*     */     else {
/* 101 */       saveObjectArray(obj, out);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void saveObjectArray(Object obj, ObjectOutput out) throws IOException {
/* 106 */     Object[] objs = (Object[])(Object[])obj;
/* 107 */     out.writeInt(objs.length);
/* 108 */     for (int i = 0; i < objs.length; i++)
/*     */     {
/* 110 */       out.writeObject(objs[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object readData(ClassLoader loader, StreamingClass streaming, ClassMetaData metaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 121 */       int length = input.readInt();
/*     */ 
/* 123 */       if ((metaData.getArrayDepth() == 1) && (metaData.getClazz().isPrimitive()))
/*     */       {
/* 126 */         Class clazz = metaData.getClazz();
/* 127 */         if (clazz == Integer.TYPE) {
/* 128 */           int[] finalArray = new int[length];
/* 129 */           cache.putObjectInCacheRead(referenceId, finalArray);
/* 130 */           for (int i = 0; i < finalArray.length; i++) finalArray[i] = input.readInt();
/* 131 */           return finalArray;
/* 132 */         }if (clazz == Byte.TYPE) {
/* 133 */           byte[] finalArray = new byte[length];
/* 134 */           cache.putObjectInCacheRead(referenceId, finalArray);
/* 135 */           input.readFully(finalArray);
/* 136 */           return finalArray;
/* 137 */         }if (clazz == Long.TYPE) {
/* 138 */           long[] finalArray = new long[length];
/* 139 */           cache.putObjectInCacheRead(referenceId, finalArray);
/* 140 */           for (int i = 0; i < finalArray.length; i++) finalArray[i] = input.readLong();
/* 141 */           return finalArray;
/* 142 */         }if (clazz == Float.TYPE) {
/* 143 */           float[] finalArray = new float[length];
/* 144 */           cache.putObjectInCacheRead(referenceId, finalArray);
/* 145 */           for (int i = 0; i < finalArray.length; i++) finalArray[i] = input.readFloat();
/* 146 */           return finalArray;
/* 147 */         }if (clazz == Double.TYPE) {
/* 148 */           double[] finalArray = new double[length];
/* 149 */           cache.putObjectInCacheRead(referenceId, finalArray);
/* 150 */           for (int i = 0; i < finalArray.length; i++) finalArray[i] = input.readDouble();
/* 151 */           return finalArray;
/* 152 */         }if (clazz == Short.TYPE) {
/* 153 */           short[] finalArray = new short[length];
/* 154 */           cache.putObjectInCacheRead(referenceId, finalArray);
/* 155 */           for (int i = 0; i < finalArray.length; i++) finalArray[i] = input.readShort();
/* 156 */           return finalArray;
/* 157 */         }if (clazz == Character.TYPE) {
/* 158 */           char[] finalArray = new char[length];
/* 159 */           cache.putObjectInCacheRead(referenceId, finalArray);
/* 160 */           for (int i = 0; i < finalArray.length; i++) finalArray[i] = input.readChar();
/* 161 */           return finalArray;
/* 162 */         }if (clazz == Boolean.TYPE) {
/* 163 */           boolean[] finalArray = new boolean[length];
/* 164 */           cache.putObjectInCacheRead(referenceId, finalArray);
/* 165 */           for (int i = 0; i < finalArray.length; i++) finalArray[i] = input.readBoolean();
/* 166 */           return finalArray;
/*     */         }
/* 168 */         throw new RuntimeException("Unexpected datatype " + clazz.getName());
/*     */       }
/*     */ 
/* 172 */       return readObjectArray(metaData, referenceId, cache, length, input);
/*     */     }
/*     */     catch (ClassNotFoundException ex)
/*     */     {
/*     */     }
/* 177 */     throw new SerializationException(ex);
/*     */   }
/*     */ 
/*     */   private Object readObjectArray(ClassMetaData metaData, int referenceId, ObjectsCache cache, int length, ObjectInput input) throws ClassNotFoundException, IOException
/*     */   {
/* 182 */     int depth = metaData.getArrayDepth();
/*     */ 
/* 184 */     int[] depthParam = new int[metaData.getArrayDepth()];
/* 185 */     depthParam[0] = length;
/* 186 */     for (int i = 1; i < depth; i++)
/*     */     {
/* 188 */       depthParam[i] = 0;
/*     */     }
/* 190 */     Object[] producedArray = (Object[])(Object[])Array.newInstance(metaData.getClazz(), depthParam);
/*     */ 
/* 192 */     cache.putObjectInCacheRead(referenceId, producedArray);
/*     */ 
/* 194 */     for (int i = 0; i < length; i++)
/*     */     {
/* 196 */       producedArray[i] = input.readObject();
/*     */     }
/* 198 */     return producedArray;
/*     */   }
/*     */ 
/*     */   public boolean canPersist(Object obj)
/*     */   {
/* 204 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.persister.ArrayPersister
 * JD-Core Version:    0.6.0
 */