/*     */ package org.jboss.serial.objectmetamodel;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaDataSlot;
/*     */ import org.jboss.serial.finalcontainers.BooleanContainer;
/*     */ import org.jboss.serial.finalcontainers.ByteContainer;
/*     */ import org.jboss.serial.finalcontainers.CharacterContainer;
/*     */ import org.jboss.serial.finalcontainers.DoubleContainer;
/*     */ import org.jboss.serial.finalcontainers.FinalContainer;
/*     */ import org.jboss.serial.finalcontainers.FloatContainer;
/*     */ import org.jboss.serial.finalcontainers.IntegerContainer;
/*     */ import org.jboss.serial.finalcontainers.LongContainer;
/*     */ import org.jboss.serial.finalcontainers.ShortContainer;
/*     */ 
/*     */ public class FieldsContainer
/*     */ {
/*     */   ClassMetaDataSlot metaData;
/*  44 */   protected HashMap fields = new HashMap();
/*     */ 
/*     */   public static void writeField(ObjectOutput out, Map.Entry entry)
/*     */     throws IOException
/*     */   {
/*  60 */     out.writeUTF((String)entry.getKey());
/*     */ 
/*  62 */     Object value = entry.getValue();
/*  63 */     if ((value instanceof FinalContainer))
/*     */     {
/*  65 */       if ((value instanceof BooleanContainer))
/*     */       {
/*  67 */         out.writeByte(12);
/*  68 */         out.writeBoolean(((BooleanContainer)value).getValue());
/*     */       }
/*  71 */       else if ((value instanceof ByteContainer))
/*     */       {
/*  73 */         out.writeByte(9);
/*  74 */         out.writeByte(((ByteContainer)value).getValue());
/*     */       }
/*  77 */       else if ((value instanceof CharacterContainer))
/*     */       {
/*  79 */         out.writeByte(11);
/*  80 */         out.writeChar(((CharacterContainer)value).getValue());
/*     */       }
/*  83 */       else if ((value instanceof DoubleContainer))
/*     */       {
/*  85 */         out.writeByte(5);
/*  86 */         out.writeDouble(((DoubleContainer)value).getValue());
/*     */       }
/*  89 */       else if ((value instanceof FloatContainer))
/*     */       {
/*  91 */         out.writeByte(10);
/*  92 */         out.writeFloat(((FloatContainer)value).getValue());
/*     */       }
/*  95 */       else if ((value instanceof IntegerContainer))
/*     */       {
/*  97 */         out.writeByte(6);
/*  98 */         out.writeInt(((IntegerContainer)value).getValue());
/*     */       }
/* 101 */       else if ((value instanceof LongContainer))
/*     */       {
/* 103 */         out.writeByte(7);
/* 104 */         out.writeLong(((LongContainer)value).getValue());
/*     */       }
/* 107 */       else if ((value instanceof ShortContainer))
/*     */       {
/* 109 */         out.writeByte(8);
/* 110 */         out.writeShort(((ShortContainer)value).getValue());
/*     */       }
/*     */       else
/*     */       {
/* 114 */         throw new RuntimeException("Unexpected datatype " + value.getClass().getName());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 119 */       out.writeByte(3);
/* 120 */       out.writeObject(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeMyself(ObjectOutput output) throws IOException
/*     */   {
/* 126 */     output.writeInt(this.fields.size());
/* 127 */     Iterator iter = this.fields.entrySet().iterator();
/* 128 */     while (iter.hasNext())
/*     */     {
/* 130 */       Map.Entry entry = (Map.Entry)iter.next();
/* 131 */       writeField(output, entry);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Map.Entry readField(ObjectInput input)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 147 */     String name = input.readUTF();
/* 148 */     byte datatype = input.readByte();
/*     */ 
/* 150 */     Object value = null;
/* 151 */     switch (datatype)
/*     */     {
/*     */     case 12:
/* 154 */       value = BooleanContainer.valueOf(input.readBoolean()); break;
/*     */     case 9:
/* 157 */       value = new ByteContainer(input.readByte()); break;
/*     */     case 11:
/* 160 */       value = new CharacterContainer(input.readChar()); break;
/*     */     case 5:
/* 163 */       value = new DoubleContainer(input.readDouble()); break;
/*     */     case 10:
/* 166 */       value = new FloatContainer(input.readFloat()); break;
/*     */     case 6:
/* 169 */       value = new IntegerContainer(input.readInt()); break;
/*     */     case 7:
/* 172 */       value = new LongContainer(input.readLong()); break;
/*     */     case 8:
/* 175 */       value = new ShortContainer(input.readShort()); break;
/*     */     case 3:
/* 178 */       value = input.readObject(); break;
/*     */     case 4:
/*     */     default:
/* 181 */       throw new RuntimeException("Unexpected datatype " + datatype);
/*     */     }
/*     */ 
/* 185 */     return new EntryImpl(name, value);
/*     */   }
/*     */ 
/*     */   public void readMyself(ObjectInput input)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 213 */     this.fields.clear();
/* 214 */     int numberOfFields = input.readInt();
/*     */ 
/* 216 */     for (int i = 0; i < numberOfFields; i++)
/*     */     {
/* 218 */       Map.Entry entry = readField(input);
/* 219 */       setField((String)entry.getKey(), entry.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setField(String name, Object value)
/*     */   {
/* 226 */     this.fields.put(name, value);
/*     */   }
/*     */ 
/*     */   public FieldsContainer(ClassMetaDataSlot metaData)
/*     */   {
/* 232 */     this.metaData = metaData;
/*     */   }
/*     */ 
/*     */   public ObjectInputStream.GetField createGet()
/*     */   {
/* 238 */     return new GetFieldImpl();
/*     */   }
/*     */ 
/*     */   public ObjectOutputStream.PutField createPut()
/*     */   {
/* 243 */     return new PutFieldImpl();
/*     */   }
/*     */ 
/*     */   class PutFieldImpl extends ObjectOutputStream.PutField
/*     */   {
/*     */     PutFieldImpl()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void put(String name, boolean val)
/*     */     {
/* 393 */       FieldsContainer.this.setField(name, new Boolean(val));
/*     */     }
/*     */ 
/*     */     public void put(String name, byte val)
/*     */     {
/* 398 */       FieldsContainer.this.setField(name, new Byte(val));
/*     */     }
/*     */ 
/*     */     public void put(String name, char val)
/*     */     {
/* 403 */       FieldsContainer.this.setField(name, new Character(val));
/*     */     }
/*     */ 
/*     */     public void put(String name, short val)
/*     */     {
/* 408 */       FieldsContainer.this.setField(name, new Short(val));
/*     */     }
/*     */ 
/*     */     public void put(String name, int val)
/*     */     {
/* 413 */       FieldsContainer.this.setField(name, new Integer(val));
/*     */     }
/*     */ 
/*     */     public void put(String name, long val)
/*     */     {
/* 418 */       FieldsContainer.this.setField(name, new Long(val));
/*     */     }
/*     */ 
/*     */     public void put(String name, float val)
/*     */     {
/* 423 */       FieldsContainer.this.setField(name, new Float(val));
/*     */     }
/*     */ 
/*     */     public void put(String name, double val)
/*     */     {
/* 428 */       FieldsContainer.this.setField(name, new Double(val));
/*     */     }
/*     */ 
/*     */     public void put(String name, Object val)
/*     */     {
/* 433 */       FieldsContainer.this.setField(name, val);
/*     */     }
/*     */ 
/*     */     public void write(ObjectOutput out) throws IOException
/*     */     {
/* 438 */       FieldsContainer.this.writeMyself(out);
/*     */     }
/*     */   }
/*     */ 
/*     */   class GetFieldImpl extends ObjectInputStream.GetField
/*     */   {
/*     */     public GetFieldImpl()
/*     */     {
/*     */     }
/*     */ 
/*     */     public ObjectStreamClass getObjectStreamClass()
/*     */     {
/* 253 */       return ObjectStreamClass.lookup(FieldsContainer.this.metaData.getSlotClass());
/*     */     }
/*     */ 
/*     */     public boolean defaulted(String name) throws IOException
/*     */     {
/* 258 */       return FieldsContainer.this.fields.get(name) == null;
/*     */     }
/*     */ 
/*     */     public boolean get(String name, boolean val)
/*     */       throws IOException
/*     */     {
/* 264 */       Boolean ret = (Boolean)FieldsContainer.this.fields.get(name);
/*     */ 
/* 266 */       if (ret == null)
/*     */       {
/* 268 */         return val;
/*     */       }
/*     */ 
/* 271 */       return ret.booleanValue();
/*     */     }
/*     */ 
/*     */     public byte get(String name, byte val)
/*     */       throws IOException
/*     */     {
/* 277 */       Byte ret = (Byte)FieldsContainer.this.fields.get(name);
/*     */ 
/* 279 */       if (ret == null)
/*     */       {
/* 281 */         return val;
/*     */       }
/*     */ 
/* 285 */       return ret.byteValue();
/*     */     }
/*     */ 
/*     */     public char get(String name, char val)
/*     */       throws IOException
/*     */     {
/* 292 */       Character ret = (Character)FieldsContainer.this.fields.get(name);
/*     */ 
/* 294 */       if (ret == null)
/*     */       {
/* 296 */         return val;
/*     */       }
/*     */ 
/* 300 */       return ret.charValue();
/*     */     }
/*     */ 
/*     */     public short get(String name, short val)
/*     */       throws IOException
/*     */     {
/* 306 */       Short ret = (Short)FieldsContainer.this.fields.get(name);
/*     */ 
/* 308 */       if (ret == null)
/*     */       {
/* 310 */         return val;
/*     */       }
/*     */ 
/* 314 */       return ret.shortValue();
/*     */     }
/*     */ 
/*     */     public int get(String name, int val)
/*     */       throws IOException
/*     */     {
/* 320 */       Integer ret = (Integer)FieldsContainer.this.fields.get(name);
/*     */ 
/* 322 */       if (ret == null)
/*     */       {
/* 324 */         return val;
/*     */       }
/*     */ 
/* 328 */       return ret.intValue();
/*     */     }
/*     */ 
/*     */     public long get(String name, long val)
/*     */       throws IOException
/*     */     {
/* 334 */       Long ret = (Long)FieldsContainer.this.fields.get(name);
/*     */ 
/* 336 */       if (ret == null)
/*     */       {
/* 338 */         return val;
/*     */       }
/*     */ 
/* 342 */       return ret.longValue();
/*     */     }
/*     */ 
/*     */     public float get(String name, float val)
/*     */       throws IOException
/*     */     {
/* 348 */       Float ret = (Float)FieldsContainer.this.fields.get(name);
/*     */ 
/* 350 */       if (ret == null)
/*     */       {
/* 352 */         return val;
/*     */       }
/*     */ 
/* 356 */       return ret.floatValue();
/*     */     }
/*     */ 
/*     */     public double get(String name, double val)
/*     */       throws IOException
/*     */     {
/* 362 */       Double ret = (Double)FieldsContainer.this.fields.get(name);
/*     */ 
/* 364 */       if (ret == null)
/*     */       {
/* 366 */         return val;
/*     */       }
/*     */ 
/* 370 */       return ret.doubleValue();
/*     */     }
/*     */ 
/*     */     public Object get(String name, Object val)
/*     */       throws IOException
/*     */     {
/* 376 */       Object ret = FieldsContainer.this.fields.get(name);
/*     */ 
/* 378 */       if (ret == null)
/*     */       {
/* 380 */         return val;
/*     */       }
/*     */ 
/* 384 */       return ret;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class EntryImpl
/*     */     implements Map.Entry
/*     */   {
/*     */     private Object key;
/*     */     private Object value;
/*     */ 
/*     */     public EntryImpl(Object key, Object value)
/*     */     {
/* 195 */       this.key = key;
/* 196 */       this.value = value;
/*     */     }
/*     */     public Object getKey() {
/* 199 */       return this.key;
/*     */     }
/*     */ 
/*     */     public Object getValue() {
/* 203 */       return this.value;
/*     */     }
/*     */ 
/*     */     public Object setValue(Object value) {
/* 207 */       throw new RuntimeException("method not supported");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.objectmetamodel.FieldsContainer
 * JD-Core Version:    0.6.0
 */