/*    */ package org.jboss.serial.io;
/*    */ 
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.ByteArrayOutputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.Serializable;
/*    */ import java.util.Arrays;
/*    */ 
/*    */ public class MarshalledObject
/*    */   implements Serializable
/*    */ {
/*    */   private byte[] bytes;
/*    */   private int hash;
/*    */   static final long serialVersionUID = -1433248532959364465L;
/*    */ 
/*    */   public MarshalledObject()
/*    */   {
/*    */   }
/*    */ 
/*    */   public MarshalledObject(Object obj)
/*    */     throws IOException
/*    */   {
/* 49 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 50 */     JBossObjectOutputStream mvos = new JBossObjectOutputStream(baos);
/* 51 */     mvos.writeObject(obj);
/* 52 */     mvos.flush();
/* 53 */     this.bytes = baos.toByteArray();
/* 54 */     mvos.close();
/* 55 */     this.hash = 0;
/* 56 */     for (int i = 0; i < this.bytes.length; i++)
/*    */     {
/* 58 */       this.hash += this.bytes[i];
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object get() throws IOException, ClassNotFoundException
/*    */   {
/* 64 */     ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
/* 65 */     JBossObjectInputStream ois = new JBossObjectInputStream(bais);
/*    */     try
/*    */     {
/* 68 */       Object localObject1 = ois.readObject();
/*    */       return localObject1;
/*    */     }
/*    */     finally
/*    */     {
/* 72 */       ois.close();
/* 73 */       bais.close();
/* 74 */     }throw localObject2;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o)
/*    */   {
/* 79 */     if (this == o) return true;
/* 80 */     if ((o == null) || (getClass() != o.getClass())) return false;
/*    */ 
/* 82 */     MarshalledObject that = (MarshalledObject)o;
/*    */ 
/* 84 */     return Arrays.equals(this.bytes, that.bytes);
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 91 */     return this.hash;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.io.MarshalledObject
 * JD-Core Version:    0.6.0
 */