/*     */ package org.jboss.serial.io;
/*     */ 
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.Field;
/*     */ import org.jboss.serial.exception.SerializationException;
/*     */ import org.jboss.serial.objectmetamodel.DataContainer;
/*     */ import org.jboss.serial.objectmetamodel.DataContainerConstants;
/*     */ import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
/*     */ import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
/*     */ import org.jboss.serial.util.StringUtil;
/*     */ import org.jboss.serial.util.StringUtilBuffer;
/*     */ 
/*     */ public class JBossObjectOutputStream extends ObjectOutputStream
/*     */   implements DataContainerConstants
/*     */ {
/*     */   OutputStream output;
/*     */   DataOutputStream dataOutput;
/*  44 */   boolean checkSerializableClass = false;
/*     */   static Field fieldEnableReplace;
/*     */   StringUtilBuffer buffer;
/*     */ 
/*     */   protected ObjectSubstitutionInterface getSubstitutionInterface()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/*  68 */       if (fieldEnableReplace.getBoolean(this))
/*     */       {
/*  70 */         return new ObjectSubstitutionInterface()
/*     */         {
/*     */           public Object replaceObject(Object obj) throws IOException {
/*  73 */             return JBossObjectOutputStream.this.replaceObject(obj);
/*     */           }
/*     */         };
/*     */       }
/*  78 */       return null;
/*     */     }
/*     */     catch (IllegalAccessException ex)
/*     */     {
/*     */     }
/*  83 */     throw new SerializationException(ex.getMessage(), ex);
/*     */   }
/*     */ 
/*     */   protected boolean enableReplaceObject(boolean enable)
/*     */   {
/*     */     try
/*     */     {
/*  92 */       if (enable == fieldEnableReplace.getBoolean(this)) {
/*  93 */         return enable;
/*     */       }
/*  95 */       fieldEnableReplace.setBoolean(this, enable);
/*  96 */       return !fieldEnableReplace.getBoolean(this);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 100 */       e.printStackTrace();
/*     */     }
/* 102 */     return super.enableReplaceObject(enable);
/*     */   }
/*     */ 
/*     */   public JBossObjectOutputStream(OutputStream output)
/*     */     throws IOException
/*     */   {
/* 110 */     this(output, false);
/*     */   }
/*     */ 
/*     */   public JBossObjectOutputStream(OutputStream output, StringUtilBuffer buffer)
/*     */     throws IOException
/*     */   {
/* 116 */     this(output, false, buffer);
/*     */   }
/*     */ 
/*     */   public JBossObjectOutputStream(OutputStream output, boolean checkSerializableClass) throws IOException
/*     */   {
/* 121 */     this(output, checkSerializableClass, null);
/*     */   }
/*     */ 
/*     */   public JBossObjectOutputStream(OutputStream output, boolean checkSerializableClass, StringUtilBuffer buffer)
/*     */     throws IOException
/*     */   {
/* 128 */     if (output != null)
/*     */     {
/* 130 */       output.write(openSign);
/*     */     }
/*     */ 
/* 133 */     this.buffer = buffer;
/* 134 */     this.output = output;
/* 135 */     this.checkSerializableClass = checkSerializableClass;
/*     */ 
/* 137 */     if ((output instanceof DataOutputStream))
/*     */     {
/* 139 */       this.dataOutput = ((DataOutputStream)output);
/*     */     }
/*     */     else
/*     */     {
/* 143 */       this.dataOutput = new DataOutputStream(output);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeObjectUsingDataContainer(Object obj) throws IOException {
/* 148 */     DataContainer dataContainer = new DataContainer(null, getSubstitutionInterface(), this.checkSerializableClass, this.buffer);
/* 149 */     if ((this.output instanceof DataOutputStream))
/*     */     {
/* 151 */       this.dataOutput = ((DataOutputStream)this.output);
/*     */     }
/*     */     else
/*     */     {
/* 155 */       this.dataOutput = new DataOutputStream(this.output);
/*     */     }
/*     */ 
/* 158 */     ObjectOutput objectOutput = dataContainer.getOutput();
/* 159 */     objectOutput.writeObject(obj);
/*     */ 
/* 162 */     dataContainer.saveData(this.dataOutput);
/*     */   }
/*     */ 
/*     */   protected void writeObjectOverride(Object obj)
/*     */     throws IOException
/*     */   {
/* 168 */     DataContainer dataContainer = new DataContainer(null, getSubstitutionInterface(), this.checkSerializableClass, this.buffer);
/* 169 */     if ((this.output instanceof DataOutputStream))
/*     */     {
/* 171 */       this.dataOutput = ((DataOutputStream)this.output);
/*     */     }
/*     */     else
/*     */     {
/* 175 */       this.dataOutput = new DataOutputStream(this.output);
/*     */     }
/*     */ 
/* 178 */     dataContainer.setStringBuffer(this.buffer);
/*     */ 
/* 180 */     ObjectOutput objectOutput = dataContainer.getDirectOutput(this.dataOutput);
/* 181 */     objectOutput.writeObject(obj);
/*     */   }
/*     */ 
/*     */   public void writeUnshared(Object obj)
/*     */     throws IOException
/*     */   {
/* 190 */     writeObjectOverride(obj);
/*     */   }
/*     */ 
/*     */   public void defaultWriteObject()
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void writeFields()
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void writeStreamHeader() throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void write(int val) throws IOException
/*     */   {
/* 218 */     this.dataOutput.write(val);
/*     */   }
/*     */ 
/*     */   public void write(byte[] buf)
/*     */     throws IOException
/*     */   {
/* 229 */     this.dataOutput.write(buf);
/*     */   }
/*     */ 
/*     */   public void write(byte[] buf, int off, int len) throws IOException {
/* 233 */     if (buf == null) {
/* 234 */       throw new SerializationException("buf parameter can't be null");
/*     */     }
/* 236 */     this.dataOutput.write(buf, off, len);
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */     throws IOException
/*     */   {
/* 246 */     if (this.dataOutput != null)
/*     */     {
/* 248 */       this.dataOutput.flush();
/*     */     }
/*     */     else
/*     */     {
/* 252 */       this.output.flush();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void drain() throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void close() throws IOException {
/* 261 */     flush();
/* 262 */     this.dataOutput.close();
/*     */   }
/*     */ 
/*     */   public void writeBoolean(boolean val) throws IOException {
/* 266 */     this.dataOutput.writeBoolean(val);
/*     */   }
/*     */ 
/*     */   public void writeByte(int val) throws IOException {
/* 270 */     this.dataOutput.writeByte(val);
/*     */   }
/*     */ 
/*     */   public void writeShort(int val) throws IOException {
/* 274 */     this.dataOutput.writeShort(val);
/*     */   }
/*     */ 
/*     */   public void writeChar(int val) throws IOException {
/* 278 */     this.dataOutput.writeChar(val);
/*     */   }
/*     */ 
/*     */   public void writeInt(int val) throws IOException {
/* 282 */     this.dataOutput.writeInt(val);
/*     */   }
/*     */ 
/*     */   public void writeLong(long val) throws IOException {
/* 286 */     this.dataOutput.writeLong(val);
/*     */   }
/*     */ 
/*     */   public void writeFloat(float val) throws IOException {
/* 290 */     this.dataOutput.writeFloat(val);
/*     */   }
/*     */ 
/*     */   public void writeDouble(double val) throws IOException {
/* 294 */     this.dataOutput.writeDouble(val);
/*     */   }
/*     */ 
/*     */   public void writeBytes(String str) throws IOException {
/* 298 */     this.dataOutput.writeBytes(str);
/*     */   }
/*     */ 
/*     */   public void writeChars(String str) throws IOException {
/* 302 */     this.dataOutput.writeChars(str);
/*     */   }
/*     */ 
/*     */   public void writeUTF(String str) throws IOException {
/* 306 */     StringUtil.saveString(this.dataOutput, str, this.buffer);
/*     */   }
/*     */ 
/*     */   public Object smartClone(Object obj)
/*     */     throws IOException
/*     */   {
/* 312 */     return smartClone(obj, null, Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   public Object smartClone(Object obj, SafeCloningRepository safeToReuse)
/*     */     throws IOException
/*     */   {
/* 318 */     return smartClone(obj, safeToReuse, Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   public Object smartClone(Object obj, SafeCloningRepository safeToReuse, ClassLoader loader)
/*     */     throws IOException
/*     */   {
/* 326 */     DataContainer container = new DataContainer(loader, getSubstitutionInterface(), safeToReuse, this.checkSerializableClass, this.buffer);
/* 327 */     ObjectOutput output = container.getOutput();
/* 328 */     output.writeObject(obj);
/* 329 */     output.flush();
/*     */ 
/* 331 */     ObjectInput input = container.getInput();
/*     */     try
/*     */     {
/* 334 */       return input.readObject();
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 338 */     throw new SerializationException(e.getMessage(), e);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  56 */       fieldEnableReplace = ObjectOutputStream.class.getDeclaredField("enableReplace");
/*  57 */       fieldEnableReplace.setAccessible(true);
/*     */     } catch (NoSuchFieldException e) {
/*  59 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.io.JBossObjectOutputStream
 * JD-Core Version:    0.6.0
 */