/*    */ package org.jboss.serial.finalcontainers;
/*    */ 
/*    */ import java.io.DataInput;
/*    */ import java.io.DataOutput;
/*    */ import java.io.IOException;
/*    */ import java.lang.reflect.Field;
/*    */ 
/*    */ public class ShortContainer extends FinalContainer
/*    */ {
/*    */   short value;
/*    */ 
/*    */   public ShortContainer(short value)
/*    */   {
/* 39 */     this.value = value;
/*    */   }
/*    */ 
/*    */   public ShortContainer() {
/*    */   }
/*    */ 
/*    */   public short getValue() {
/* 46 */     return this.value;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o) {
/* 50 */     if (this == o) return true;
/* 51 */     if ((o == null) || (getClass() != o.getClass())) return false;
/*    */ 
/* 53 */     ShortContainer that = (ShortContainer)o;
/*    */ 
/* 55 */     return this.value == that.value;
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 61 */     return this.value;
/*    */   }
/*    */ 
/*    */   public void writeMyself(DataOutput output) throws IOException
/*    */   {
/* 66 */     output.writeShort(this.value);
/*    */   }
/*    */ 
/*    */   public void readMyself(DataInput input) throws IOException
/*    */   {
/* 71 */     this.value = input.readShort();
/*    */   }
/*    */ 
/*    */   public void setPrimitive(Object obj, Field field) throws IllegalAccessException {
/* 75 */     field.setShort(obj, this.value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.finalcontainers.ShortContainer
 * JD-Core Version:    0.6.0
 */