/*    */ package org.jboss.serial.finalcontainers;
/*    */ 
/*    */ import java.io.DataInput;
/*    */ import java.io.DataOutput;
/*    */ import java.io.IOException;
/*    */ import java.lang.reflect.Field;
/*    */ 
/*    */ public class FloatContainer extends FinalContainer
/*    */ {
/*    */   float value;
/*    */ 
/*    */   public FloatContainer(float value)
/*    */   {
/* 39 */     this.value = value;
/*    */   }
/*    */ 
/*    */   public FloatContainer() {
/*    */   }
/*    */ 
/*    */   public float getValue() {
/* 46 */     return this.value;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o) {
/* 50 */     if (this == o) return true;
/* 51 */     if ((o == null) || (getClass() != o.getClass())) return false;
/*    */ 
/* 53 */     FloatContainer that = (FloatContainer)o;
/*    */ 
/* 55 */     return Float.compare(that.value, this.value) == 0;
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 61 */     return this.value != 0.0F ? Float.floatToIntBits(this.value) : 0;
/*    */   }
/*    */ 
/*    */   public void writeMyself(DataOutput output) throws IOException
/*    */   {
/* 66 */     output.writeFloat(this.value);
/*    */   }
/*    */ 
/*    */   public void readMyself(DataInput input) throws IOException
/*    */   {
/* 71 */     this.value = input.readFloat();
/*    */   }
/*    */ 
/*    */   public void setPrimitive(Object obj, Field field) throws IllegalAccessException {
/* 75 */     field.setFloat(obj, this.value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.finalcontainers.FloatContainer
 * JD-Core Version:    0.6.0
 */