/*    */ package org.jboss.serial.finalcontainers;
/*    */ 
/*    */ import java.io.DataInput;
/*    */ import java.io.DataOutput;
/*    */ import java.io.IOException;
/*    */ import java.lang.reflect.Field;
/*    */ 
/*    */ public class BooleanContainer extends FinalContainer
/*    */ {
/* 37 */   private static BooleanContainer TRUE = new BooleanContainer(true);
/* 38 */   private static BooleanContainer FALSE = new BooleanContainer(false);
/*    */   boolean value;
/*    */ 
/*    */   public static BooleanContainer valueOf(boolean value)
/*    */   {
/* 43 */     return value ? TRUE : FALSE;
/*    */   }
/*    */ 
/*    */   private BooleanContainer(boolean value) {
/* 47 */     this.value = value;
/*    */   }
/*    */ 
/*    */   public boolean getValue() {
/* 51 */     return this.value;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o) {
/* 55 */     if (this == o) return true;
/* 56 */     if ((o == null) || (getClass() != o.getClass())) return false;
/*    */ 
/* 58 */     BooleanContainer that = (BooleanContainer)o;
/*    */ 
/* 60 */     return this.value == that.value;
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 66 */     return this.value ? 1 : 0;
/*    */   }
/*    */ 
/*    */   public void writeMyself(DataOutput output) throws IOException {
/* 70 */     output.writeBoolean(this.value);
/*    */   }
/*    */ 
/*    */   public void readMyself(DataInput input) throws IOException {
/* 74 */     this.value = input.readBoolean();
/*    */   }
/*    */ 
/*    */   public void setPrimitive(Object obj, Field field) throws IllegalAccessException {
/* 78 */     field.setBoolean(obj, this.value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.finalcontainers.BooleanContainer
 * JD-Core Version:    0.6.0
 */