/*     */ package org.jboss.serial.classmetamodel;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import sun.reflect.ReflectionFactory;
/*     */ 
/*     */ public class SunConstructorManager extends ConstructorManager
/*     */ {
/*  40 */   static boolean supported = true;
/*     */   static ReflectionFactory reflectionFactory;
/*     */ 
/*     */   public Constructor getConstructor(Class clazz)
/*     */     throws SecurityException, NoSuchMethodException
/*     */   {
/*  63 */     if (clazz.isInterface())
/*     */     {
/*  65 */       throw new NoSuchMethodException("Can't create a constructor for a pure interface");
/*     */     }
/*     */ 
/*  68 */     if (!Serializable.class.isAssignableFrom(clazz))
/*     */     {
/*  70 */       Constructor constr = clazz.getDeclaredConstructor(EMPTY_CLASS_ARRY);
/*  71 */       constr.setAccessible(true);
/*  72 */       return constr;
/*     */     }
/*     */ 
/*  75 */     if (Externalizable.class.isAssignableFrom(clazz))
/*     */     {
/*  77 */       Constructor constr = clazz.getConstructor(EMPTY_CLASS_ARRY);
/*  78 */       constr.setAccessible(true);
/*  79 */       return constr;
/*     */     }
/*     */ 
/*  83 */     Class currentClass = clazz;
/*  84 */     while (Serializable.class.isAssignableFrom(currentClass))
/*     */     {
/*  86 */       currentClass = currentClass.getSuperclass();
/*     */     }
/*  88 */     Constructor constr = currentClass.getDeclaredConstructor(EMPTY_CLASS_ARRY);
/*  89 */     constr.setAccessible(true);
/*     */ 
/*  92 */     Constructor newConstructor = reflectionFactory.newConstructorForSerialization(clazz, constr);
/*  93 */     newConstructor.setAccessible(true);
/*     */ 
/*  95 */     return newConstructor;
/*     */   }
/*     */ 
/*     */   public boolean isSupported()
/*     */   {
/* 104 */     return supported;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  46 */       reflectionFactory = ReflectionFactory.getReflectionFactory();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  50 */       e.printStackTrace();
/*  51 */       supported = false;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.classmetamodel.SunConstructorManager
 * JD-Core Version:    0.6.0
 */