/*     */ package org.jboss.serial.classmetamodel;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ 
/*     */ public class StreamingClass
/*     */ {
/*     */   ClassMetaData metadata;
/*     */   private short[][] keyFields;
/*     */ 
/*     */   public StreamingClass(Class clazz)
/*     */     throws IOException
/*     */   {
/*  39 */     this.metadata = ClassMetamodelFactory.getClassMetaData(clazz, false);
/*     */   }
/*     */ 
/*     */   public StreamingClass(ClassMetaData clazz) throws IOException {
/*  43 */     this.metadata = clazz;
/*     */   }
/*     */ 
/*     */   public static void saveStream(ClassMetaData metadata, ObjectOutput out)
/*     */     throws IOException
/*     */   {
/*  54 */     out.writeUTF(metadata.getClassName());
/*  55 */     ClassMetaDataSlot[] slots = metadata.getSlots();
/*  56 */     out.writeShort(slots.length);
/*  57 */     for (int slotNR = 0; slotNR < slots.length; slotNR++)
/*     */     {
/*  59 */       out.writeLong(slots[slotNR].getShaHash());
/*  60 */       ClassMetadataField[] fields = slots[slotNR].getFields();
/*  61 */       out.writeShort(fields.length);
/*  62 */       for (int fieldNR = 0; fieldNR < fields.length; fieldNR++)
/*     */       {
/*  64 */         out.writeLong(fields[fieldNR].getShaHash());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static StreamingClass readStream(ObjectInput inp, ClassResolver resolver, ClassLoader loader) throws IOException
/*     */   {
/*  71 */     String className = inp.readUTF();
/*  72 */     ClassMetaData metadata = ClassMetamodelFactory.getClassMetaData(className, resolver, loader, false);
/*  73 */     StreamingClass streamClass = new StreamingClass(metadata);
/*     */ 
/*  76 */     short slotsNrOnStreaming = inp.readShort();
/*  77 */     ClassMetaDataSlot[] slots = metadata.getSlots();
/*  78 */     if (slotsNrOnStreaming != slots.length)
/*     */     {
/*  80 */       throw new IOException("The hierarchy of " + className + " is different in your current classPath");
/*     */     }
/*     */ 
/*  83 */     short[][] keyfields = new short[slots.length][];
/*     */ 
/*  85 */     for (int slotIndex = 0; slotIndex < slots.length; slotIndex++)
/*     */     {
/*  87 */       long shaSlotHash = inp.readLong();
/*  88 */       if (slots[slotIndex].getShaHash() != shaSlotHash)
/*     */       {
/*  90 */         throw new IOException("The hierarchy of " + className + " is different in your current classPath");
/*     */       }
/*  92 */       short numberofFields = inp.readShort();
/*  93 */       keyfields[slotIndex] = new short[numberofFields];
/*     */ 
/*  95 */       ClassMetadataField[] fields = slots[slotIndex].getFields();
/*  96 */       if (numberofFields > fields.length)
/*     */       {
/*  98 */         throw new IOException("Current classpath has lesser fields on " + className + " than its original version");
/*     */       }
/* 100 */       for (short fieldIndex = 0; fieldIndex < fields.length; fieldIndex = (short)(fieldIndex + 1))
/*     */       {
/* 102 */         long hashfield = inp.readLong();
/* 103 */         ClassMetadataField fieldOnHash = slots[slotIndex].getField(hashfield);
/* 104 */         if (fieldOnHash == null)
/*     */         {
/* 106 */           throw new IOException("Field hash " + fieldOnHash + " is not available on current classPath for class " + className);
/*     */         }
/* 108 */         keyfields[slotIndex][fieldIndex] = fieldOnHash.getOrder();
/*     */       }
/*     */     }
/*     */ 
/* 112 */     streamClass.keyFields = keyfields;
/*     */ 
/* 114 */     return streamClass;
/*     */   }
/*     */ 
/*     */   public short[][] getKeyFields()
/*     */   {
/* 119 */     return this.keyFields;
/*     */   }
/*     */ 
/*     */   public void setKeyFields(short[][] keyFields)
/*     */   {
/* 124 */     this.keyFields = keyFields;
/*     */   }
/*     */ 
/*     */   public ClassMetaData getMetadata() {
/* 128 */     return this.metadata;
/*     */   }
/*     */   public void setMetadata(ClassMetaData metadata) {
/* 131 */     this.metadata = metadata;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.classmetamodel.StreamingClass
 * JD-Core Version:    0.6.0
 */