/*     */ package org.jboss.serial.classmetamodel;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import org.jboss.serial.references.MethodPersistentReference;
/*     */ import org.jboss.serial.references.PersistentReference;
/*     */ import org.jboss.serial.util.ClassMetaConsts;
/*     */ import org.jboss.serial.util.HashStringUtil;
/*     */ 
/*     */ public class ClassMetaDataSlot
/*     */   implements ClassMetaConsts
/*     */ {
/*     */   WeakReference slotClass;
/*     */   String name;
/* 131 */   HashMap fields = new HashMap();
/* 132 */   TLongObjectHashMap hashFields = new TLongObjectHashMap();
/*     */   long shaHash;
/* 135 */   PersistentReference privateMethodWrite = emptyReference;
/* 136 */   PersistentReference privateMethodRead = emptyReference;
/*     */   ClassMetadataField[] fieldsCollection;
/*     */ 
/*     */   public ClassMetaDataSlot(Class slotClass)
/*     */   {
/*  48 */     this.slotClass = new WeakReference(slotClass);
/*  49 */     this.name = slotClass.getName();
/*  50 */     this.shaHash = HashStringUtil.hashName(this.name);
/*     */ 
/*  52 */     if (!Serializable.class.isAssignableFrom(slotClass))
/*     */     {
/*  54 */       explorefieldsNonSerializable(slotClass);
/*     */     }
/*     */     else
/*     */     {
/*  58 */       exploreFields(slotClass);
/*     */     }
/*  60 */     explorePrivateMethod(slotClass);
/*     */   }
/*     */ 
/*     */   private void explorePrivateMethod(Class slotClass)
/*     */   {
/*  65 */     Method method = null;
/*     */     try
/*     */     {
/*  68 */       method = slotClass.getDeclaredMethod("readObject", new Class[] { ObjectInputStream.class });
/*  69 */       method.setAccessible(true);
/*  70 */       setPrivateMethodRead(method);
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  78 */       method = slotClass.getDeclaredMethod("writeObject", new Class[] { ObjectOutputStream.class });
/*  79 */       method.setAccessible(true);
/*  80 */       setPrivateMethodWrite(method);
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   private void exploreFields(Class slotClass)
/*     */   {
/*  89 */     Field[] fields = slotClass.getDeclaredFields();
/*  90 */     ArrayList fieldsList = new ArrayList();
/*  91 */     for (short i = 0; i < fields.length; i = (short)(i + 1))
/*     */     {
/*  93 */       if ((fields[i].getModifiers() & 0x88) != 0)
/*     */         continue;
/*  95 */       fields[i].setAccessible(true);
/*  96 */       ClassMetadataField classfield = new ClassMetadataField(fields[i]);
/*  97 */       FieldsManager.getFieldsManager().fillMetadata(classfield);
/*  98 */       addField(classfield.getShaHash(), classfield.getFieldName(), classfield);
/*  99 */       classfield.setOrder((short)fieldsList.size());
/* 100 */       fieldsList.add(classfield);
/*     */     }
/*     */ 
/* 103 */     this.fieldsCollection = ((ClassMetadataField[])(ClassMetadataField[])fieldsList.toArray(new ClassMetadataField[fieldsList.size()]));
/*     */   }
/*     */ 
/*     */   private void explorefieldsNonSerializable(Class slotClass)
/*     */   {
/* 108 */     ArrayList fieldsList = new ArrayList();
/* 109 */     while ((slotClass != null) && (slotClass != Object.class))
/*     */     {
/* 111 */       Field[] fields = slotClass.getDeclaredFields();
/* 112 */       for (short i = 0; i < fields.length; i = (short)(i + 1))
/*     */       {
/* 114 */         if ((fields[i].getModifiers() & 0x88) != 0)
/*     */           continue;
/* 116 */         fields[i].setAccessible(true);
/* 117 */         ClassMetadataField classfield = new ClassMetadataField(fields[i]);
/* 118 */         FieldsManager.getFieldsManager().fillMetadata(classfield);
/* 119 */         addField(classfield.getShaHash(), classfield.getFieldName(), classfield);
/* 120 */         classfield.setOrder((short)fieldsList.size());
/* 121 */         fieldsList.add(classfield);
/*     */       }
/*     */ 
/* 124 */       slotClass = slotClass.getSuperclass();
/*     */     }
/* 126 */     this.fieldsCollection = ((ClassMetadataField[])(ClassMetadataField[])fieldsList.toArray(new ClassMetadataField[fieldsList.size()]));
/*     */   }
/*     */ 
/*     */   public Class getSlotClass()
/*     */   {
/* 144 */     return (Class)this.slotClass.get();
/*     */   }
/*     */ 
/*     */   private void addField(long shaHashKey, String fieldName, ClassMetadataField classfield)
/*     */   {
/* 153 */     this.fields.put(fieldName, classfield);
/* 154 */     this.hashFields.put(shaHashKey, classfield);
/*     */   }
/*     */ 
/*     */   public ClassMetadataField getField(String name)
/*     */   {
/* 162 */     return (ClassMetadataField)this.fields.get(name);
/*     */   }
/*     */ 
/*     */   public ClassMetadataField getField(long shaKey)
/*     */   {
/* 167 */     return (ClassMetadataField)this.hashFields.get(shaKey);
/*     */   }
/*     */ 
/*     */   public ClassMetadataField[] getFields()
/*     */   {
/* 172 */     return this.fieldsCollection;
/*     */   }
/*     */ 
/*     */   public Method getPrivateMethodRead()
/*     */   {
/* 177 */     return (Method)this.privateMethodRead.get();
/*     */   }
/*     */ 
/*     */   public void setPrivateMethodRead(Method privateMethodRead)
/*     */   {
/* 182 */     this.privateMethodRead = new MethodPersistentReference(privateMethodRead, 2);
/*     */   }
/*     */ 
/*     */   public Method getPrivateMethodWrite()
/*     */   {
/* 187 */     return (Method)this.privateMethodWrite.get();
/*     */   }
/*     */ 
/*     */   public void setPrivateMethodWrite(Method privateMethodWrite)
/*     */   {
/* 192 */     this.privateMethodWrite = new MethodPersistentReference(privateMethodWrite, 2);
/*     */   }
/*     */ 
/*     */   public long getShaHash() {
/* 196 */     return this.shaHash;
/*     */   }
/*     */ 
/*     */   public void setShaHash(long shaHash) {
/* 200 */     this.shaHash = shaHash;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.classmetamodel.ClassMetaDataSlot
 * JD-Core Version:    0.6.0
 */