/*     */ package org.jboss.security.ssl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.Socket;
/*     */ import java.rmi.server.RMIClientSocketFactory;
/*     */ import java.security.cert.Certificate;
/*     */ import java.util.Hashtable;
/*     */ import javax.net.ssl.HandshakeCompletedEvent;
/*     */ import javax.net.ssl.HandshakeCompletedListener;
/*     */ import javax.net.ssl.SSLSession;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class RMISSLClientSocketFactory
/*     */   implements HandshakeCompletedListener, RMIClientSocketFactory, Serializable
/*     */ {
/*     */   public static final String HANDSHAKE_COMPLETE_LISTENER = "org.jboss.security.ssl.HandshakeCompletedListener";
/*  48 */   private static Logger log = Logger.getLogger(RMISSLClientSocketFactory.class);
/*     */   private static final long serialVersionUID = -6412485012870705607L;
/*  50 */   private boolean wantsClientAuth = true;
/*  51 */   private boolean needsClientAuth = false;
/*     */ 
/*     */   public boolean isWantsClientAuth()
/*     */   {
/*  60 */     return this.wantsClientAuth;
/*     */   }
/*     */ 
/*     */   public void setWantsClientAuth(boolean wantsClientAuth) {
/*  64 */     this.wantsClientAuth = wantsClientAuth;
/*     */   }
/*     */ 
/*     */   public boolean isNeedsClientAuth()
/*     */   {
/*  69 */     return this.needsClientAuth;
/*     */   }
/*     */ 
/*     */   public void setNeedsClientAuth(boolean needsClientAuth) {
/*  73 */     this.needsClientAuth = needsClientAuth;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port)
/*     */     throws IOException
/*     */   {
/*  85 */     SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
/*  86 */     SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
/*  87 */     socket.addHandshakeCompletedListener(this);
/*  88 */     socket.setWantClientAuth(this.wantsClientAuth);
/*  89 */     socket.setNeedClientAuth(this.needsClientAuth);
/*  90 */     log.debug("createSocket, host=" + host + ", port=" + port + ",needsClientAuth=" + this.needsClientAuth + ", wantsClientAuth=" + this.wantsClientAuth);
/*     */ 
/*  92 */     return socket;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  97 */     return obj instanceof RMISSLClientSocketFactory;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 101 */     return getClass().getName().hashCode();
/*     */   }
/*     */ 
/*     */   public void handshakeCompleted(HandshakeCompletedEvent event)
/*     */   {
/* 106 */     String cipher = event.getCipherSuite();
/* 107 */     SSLSession session = event.getSession();
/* 108 */     String peerHost = session.getPeerHost();
/* 109 */     Certificate[] localCerts = event.getLocalCertificates();
/* 110 */     Certificate[] peerCerts = null;
/*     */     try
/*     */     {
/* 113 */       peerCerts = event.getPeerCertificates();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 117 */       log.debug("Failed to retrieve peer certs", e);
/*     */     }
/* 119 */     log.debug("SSL handshakeCompleted, cipher=" + cipher + ", peerHost=" + peerHost);
/*     */ 
/* 121 */     int count = localCerts != null ? localCerts.length : 0;
/* 122 */     log.debug("ClientCertChain length: " + count);
/* 123 */     for (int n = 0; n < count; n++)
/* 124 */       log.debug("Cert[" + n + "]=" + localCerts[n]);
/* 125 */     count = peerCerts != null ? peerCerts.length : 0;
/* 126 */     log.debug("PeerCertChain length: " + count);
/* 127 */     for (int n = 0; n < count; n++) {
/* 128 */       log.debug("Cert[" + n + "]=" + peerCerts[n]);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 136 */       Hashtable env = System.getProperties();
/* 137 */       HandshakeCompletedListener listener = (Serializable)env.get("org.jboss.security.ssl.HandshakeCompletedListener");
/*     */ 
/* 139 */       if (listener != null)
/* 140 */         listener.handshakeCompleted(event);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 144 */       log.debug("Failed to foward handshakeCompleted", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.ssl.RMISSLClientSocketFactory
 * JD-Core Version:    0.6.0
 */