/*     */ package org.jboss.security.ssl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Arrays;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.net.ssl.HandshakeCompletedEvent;
/*     */ import javax.net.ssl.HandshakeCompletedListener;
/*     */ import javax.net.ssl.SSLContext;
/*     */ import javax.net.ssl.SSLSession;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityDomain;
/*     */ 
/*     */ public class DomainSocketFactory extends SSLSocketFactory
/*     */   implements HandshakeCompletedListener, Serializable
/*     */ {
/*     */   public static final String HANDSHAKE_COMPLETE_LISTENER = "org.jboss.security.ssl.HandshakeCompletedListener";
/*     */   private static final long serialVersionUID = -4471907598525153511L;
/*  65 */   private static Logger log = Logger.getLogger(DomainSocketFactory.class);
/*     */   private transient SecurityDomain securityDomain;
/*  67 */   private transient SSLContext sslCtx = null;
/*  68 */   private boolean wantsClientAuth = true;
/*  69 */   private boolean needsClientAuth = false;
/*     */ 
/*     */   public DomainSocketFactory()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DomainSocketFactory(SecurityDomain securityDomain)
/*     */     throws IOException
/*     */   {
/*  86 */     if (securityDomain == null)
/*  87 */       throw new IOException("The securityDomain may not be null");
/*  88 */     this.securityDomain = securityDomain;
/*     */   }
/*     */ 
/*     */   public SecurityDomain getSecurityDomain()
/*     */   {
/*  93 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(SecurityDomain securityDomain)
/*     */   {
/*  98 */     this.securityDomain = securityDomain;
/*     */   }
/*     */ 
/*     */   public boolean isWantsClientAuth()
/*     */   {
/* 103 */     return this.wantsClientAuth;
/*     */   }
/*     */ 
/*     */   public void setWantsClientAuth(boolean wantsClientAuth) {
/* 107 */     this.wantsClientAuth = wantsClientAuth;
/*     */   }
/*     */ 
/*     */   public boolean isNeedsClientAuth()
/*     */   {
/* 112 */     return this.needsClientAuth;
/*     */   }
/*     */ 
/*     */   public void setNeedsClientAuth(boolean needsClientAuth) {
/* 116 */     this.needsClientAuth = needsClientAuth;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String serverHost, int serverPort)
/*     */     throws IOException, UnknownHostException
/*     */   {
/* 132 */     InetAddress serverAddr = InetAddress.getByName(serverHost);
/* 133 */     return createSocket(serverAddr, serverPort);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String serverHost, int serverPort, int timeout)
/*     */     throws IOException, UnknownHostException
/*     */   {
/* 148 */     InetAddress serverAddr = InetAddress.getByName(serverHost);
/* 149 */     return createSocket(serverAddr, serverPort, timeout);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String serverHost, int serverPort, InetAddress clientAddr, int clientPort)
/*     */     throws IOException, UnknownHostException
/*     */   {
/* 156 */     InetAddress serverAddr = InetAddress.getByName(serverHost);
/* 157 */     return createSocket(serverAddr, serverPort, clientAddr, clientPort);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress serverAddr, int serverPort)
/*     */     throws IOException
/*     */   {
/* 163 */     return createSocket(serverAddr, serverPort, null, 0);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress serverAddr, int serverPort, InetAddress clientAddr, int clientPort)
/*     */     throws IOException
/*     */   {
/* 170 */     initSSLContext();
/* 171 */     SSLSocketFactory factory = this.sslCtx.getSocketFactory();
/* 172 */     SSLSocket socket = (SSLSocket)factory.createSocket(serverAddr, serverPort, clientAddr, clientPort);
/*     */ 
/* 175 */     String[] supportedProtocols = socket.getSupportedProtocols();
/* 176 */     log.debug("Supported protocols: " + Arrays.asList(supportedProtocols));
/* 177 */     String[] protocols = supportedProtocols;
/* 178 */     socket.setEnabledProtocols(protocols);
/* 179 */     socket.addHandshakeCompletedListener(this);
/* 180 */     socket.setNeedClientAuth(this.needsClientAuth);
/* 181 */     socket.setWantClientAuth(this.wantsClientAuth);
/* 182 */     return socket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress serverAddr, int serverPort, int timeout)
/*     */     throws IOException
/*     */   {
/* 189 */     initSSLContext();
/* 190 */     SSLSocketFactory factory = this.sslCtx.getSocketFactory();
/* 191 */     SSLSocket socket = (SSLSocket)factory.createSocket();
/* 192 */     socket.connect(new InetSocketAddress(serverAddr, serverPort), timeout);
/* 193 */     String[] supportedProtocols = socket.getSupportedProtocols();
/* 194 */     log.debug("Supported protocols: " + Arrays.asList(supportedProtocols));
/* 195 */     String[] protocols = supportedProtocols;
/* 196 */     socket.setEnabledProtocols(protocols);
/* 197 */     socket.addHandshakeCompletedListener(this);
/* 198 */     socket.setNeedClientAuth(this.needsClientAuth);
/* 199 */     socket.setWantClientAuth(this.wantsClientAuth);
/* 200 */     return socket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(Socket s, String host, int port, boolean autoClose)
/*     */     throws IOException
/*     */   {
/* 207 */     initSSLContext();
/* 208 */     SSLSocketFactory factory = this.sslCtx.getSocketFactory();
/* 209 */     SSLSocket socket = (SSLSocket)factory.createSocket(s, host, port, autoClose);
/*     */ 
/* 211 */     String[] supportedProtocols = socket.getSupportedProtocols();
/* 212 */     String[] protocols = supportedProtocols;
/* 213 */     socket.setEnabledProtocols(protocols);
/* 214 */     socket.addHandshakeCompletedListener(this);
/* 215 */     socket.setNeedClientAuth(this.needsClientAuth);
/* 216 */     socket.setWantClientAuth(this.wantsClientAuth);
/* 217 */     return socket;
/*     */   }
/*     */ 
/*     */   public String[] getDefaultCipherSuites()
/*     */   {
/* 222 */     String[] cipherSuites = new String[0];
/*     */     try
/*     */     {
/* 225 */       initSSLContext();
/* 226 */       SSLSocketFactory factory = this.sslCtx.getSocketFactory();
/* 227 */       cipherSuites = factory.getDefaultCipherSuites();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 231 */       log.error("Failed to get default SSLSocketFactory", e);
/*     */     }
/* 233 */     return cipherSuites;
/*     */   }
/*     */ 
/*     */   public String[] getSupportedCipherSuites()
/*     */   {
/* 238 */     String[] cipherSuites = new String[0];
/*     */     try
/*     */     {
/* 241 */       initSSLContext();
/* 242 */       SSLSocketFactory factory = this.sslCtx.getSocketFactory();
/* 243 */       cipherSuites = factory.getSupportedCipherSuites();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 247 */       log.error("Failed to get default SSLSocketFactory", e);
/*     */     }
/* 249 */     return cipherSuites;
/*     */   }
/*     */ 
/*     */   public static SocketFactory getDefault()
/*     */   {
/* 258 */     DomainSocketFactory ssf = null;
/*     */     try
/*     */     {
/* 261 */       InitialContext iniCtx = new InitialContext();
/* 262 */       SecurityDomain sd = (SecurityDomain)iniCtx.lookup("java:/jaas/other");
/* 263 */       ssf = new DomainSocketFactory(sd);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 267 */       log.error("Failed to create default SocketFactory", e);
/*     */     }
/* 269 */     return ssf;
/*     */   }
/*     */ 
/*     */   public void handshakeCompleted(HandshakeCompletedEvent event)
/*     */   {
/* 276 */     Logger log = Logger.getLogger(ClientSocketFactory.class);
/* 277 */     if (log.isTraceEnabled())
/*     */     {
/* 279 */       String cipher = event.getCipherSuite();
/* 280 */       SSLSession session = event.getSession();
/* 281 */       String peerHost = session.getPeerHost();
/* 282 */       log.debug("SSL handshakeCompleted, cipher=" + cipher + ", peerHost=" + peerHost);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 292 */       Hashtable env = System.getProperties();
/* 293 */       HandshakeCompletedListener listener = (Serializable)env.get("org.jboss.security.ssl.HandshakeCompletedListener");
/*     */ 
/* 295 */       if (listener != null)
/* 296 */         listener.handshakeCompleted(event);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 300 */       log.debug("Failed to foward handshakeCompleted", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void initSSLContext()
/*     */     throws IOException
/*     */   {
/* 309 */     if (this.sslCtx != null)
/* 310 */       return;
/* 311 */     this.sslCtx = Context.forDomain(this.securityDomain);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.ssl.DomainSocketFactory
 * JD-Core Version:    0.6.0
 */