/*     */ package org.jboss.security.ssl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.Socket;
/*     */ import javassist.util.proxy.MethodHandler;
/*     */ import javax.net.ssl.HandshakeCompletedEvent;
/*     */ import javax.net.ssl.HandshakeCompletedListener;
/*     */ import javax.net.ssl.SSLServerSocket;
/*     */ import javax.net.ssl.SSLSession;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ 
/*     */ class DomainServerSocket
/*     */   implements MethodHandler, HandshakeCompletedListener
/*     */ {
/*     */   private SSLServerSocket delegate;
/*     */ 
/*     */   DomainServerSocket(SSLServerSocket delegate)
/*     */   {
/*  52 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object self, Method method, Method method1, Object[] args)
/*     */     throws Exception
/*     */   {
/*  58 */     Object rtn = null;
/*  59 */     if (method.getName().equals("accept")) {
/*  60 */       rtn = accept();
/*     */     }
/*     */     else {
/*     */       try
/*     */       {
/*  65 */         rtn = method.invoke(this.delegate, args);
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/*  69 */         Throwable t = e.getTargetException();
/*  70 */         if ((t instanceof Exception))
/*  71 */           throw ((Exception)t);
/*  72 */         if ((t instanceof Error)) {
/*  73 */           throw ((Error)t);
/*     */         }
/*  75 */         throw e;
/*     */       }
/*     */     }
/*  78 */     return rtn;
/*     */   }
/*     */ 
/*     */   public Socket accept()
/*     */     throws IOException
/*     */   {
/*  84 */     SSLSocket socket = (SSLSocket)this.delegate.accept();
/*  85 */     socket.addHandshakeCompletedListener(this);
/*  86 */     return socket;
/*     */   }
/*     */ 
/*     */   public void handshakeCompleted(HandshakeCompletedEvent event)
/*     */   {
/*  91 */     SSLSession session = event.getSession();
/*  92 */     String sessionID = null;
/*  93 */     byte[] id = session.getId();
/*     */     try
/*     */     {
/*  96 */       sessionID = new String(id, "UTF-8");
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/* 100 */       sessionID = new String(id);
/*     */     }
/* 102 */     DomainServerSocketFactory.putSSLSession(sessionID, session);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.ssl.DomainServerSocket
 * JD-Core Version:    0.6.0
 */