/*    */ package org.jboss.security.ssl;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.security.KeyManagementException;
/*    */ import java.security.NoSuchAlgorithmException;
/*    */ import javax.net.ssl.KeyManagerFactory;
/*    */ import javax.net.ssl.SSLContext;
/*    */ import javax.net.ssl.TrustManager;
/*    */ import javax.net.ssl.TrustManagerFactory;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.security.SecurityDomain;
/*    */ 
/*    */ class Context
/*    */ {
/* 52 */   private static Logger log = Logger.getLogger(Context.class);
/*    */ 
/*    */   static SSLContext forDomain(SecurityDomain securityDomain)
/*    */     throws IOException
/*    */   {
/* 62 */     SSLContext sslCtx = null;
/*    */     try
/*    */     {
/* 65 */       sslCtx = SSLContext.getInstance("TLS");
/* 66 */       KeyManagerFactory keyMgr = securityDomain.getKeyManagerFactory();
/* 67 */       if (keyMgr == null)
/* 68 */         throw new IOException("KeyManagerFactory is null for security domain: " + securityDomain.getSecurityDomain());
/* 69 */       TrustManagerFactory trustMgr = securityDomain.getTrustManagerFactory();
/* 70 */       TrustManager[] trustMgrs = null;
/* 71 */       if (trustMgr != null)
/* 72 */         trustMgrs = trustMgr.getTrustManagers();
/* 73 */       sslCtx.init(keyMgr.getKeyManagers(), trustMgrs, null);
/* 74 */       return sslCtx;
/*    */     }
/*    */     catch (NoSuchAlgorithmException e)
/*    */     {
/* 78 */       log.error("Failed to get SSLContext for TLS algorithm", e);
/* 79 */       throw new IOException("Failed to get SSLContext for TLS algorithm");
/*    */     }
/*    */     catch (KeyManagementException e)
/*    */     {
/* 83 */       log.error("Failed to init SSLContext", e);
/* 84 */       throw new IOException("Failed to init SSLContext");
/*    */     }
/*    */     catch (SecurityException e)
/*    */     {
/* 88 */       log.error("Failed to init SSLContext", e);
/* 89 */     }throw new IOException("Failed to init SSLContext");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.ssl.Context
 * JD-Core Version:    0.6.0
 */