/*     */ package org.jboss.security.propertyeditor;
/*     */ 
/*     */ import java.beans.PropertyEditorSupport;
/*     */ import java.security.KeyStore;
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.net.ssl.KeyManagerFactory;
/*     */ import javax.net.ssl.TrustManagerFactory;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.message.MessageInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityDomain;
/*     */ 
/*     */ public class SecurityDomainEditor extends PropertyEditorSupport
/*     */ {
/*  56 */   private static Logger log = Logger.getLogger(SecurityDomainEditor.class);
/*     */   private String domainName;
/*     */ 
/*     */   public void setAsText(String text)
/*     */   {
/*  66 */     this.domainName = text;
/*     */     try
/*     */     {
/*  69 */       InitialContext ctx = new InitialContext();
/*  70 */       Object ref = ctx.lookup(text);
/*  71 */       SecurityDomain domain = null;
/*  72 */       if ((ref instanceof SecurityDomain))
/*     */       {
/*  74 */         domain = (SecurityDomain)ref;
/*     */       }
/*     */       else
/*     */       {
/*  79 */         domain = new SecurityDomainProxy(this.domainName);
/*     */       }
/*  81 */       setValue(domain);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  85 */       log.error("Failed to lookup SecurityDomain, " + this.domainName, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getAsText()
/*     */   {
/*  95 */     return this.domainName;
/*     */   }
/*     */ 
/*     */   static class SecurityDomainProxy
/*     */     implements SecurityDomain
/*     */   {
/*     */     SecurityDomain delegate;
/*     */     private String jndiName;
/*     */ 
/*     */     SecurityDomainProxy(String jndiName)
/*     */     {
/* 109 */       this.jndiName = jndiName;
/*     */     }
/*     */ 
/*     */     private synchronized void initDelegate()
/*     */     {
/* 114 */       if (this.delegate == null)
/*     */       {
/*     */         try
/*     */         {
/* 118 */           InitialContext ctx = new InitialContext();
/* 119 */           this.delegate = ((SecurityDomain)ctx.lookup(this.jndiName));
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 123 */           SecurityException se = new SecurityException("Failed to lookup SecurityDomain, " + this.jndiName);
/* 124 */           se.initCause(e);
/* 125 */           throw se;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public KeyStore getKeyStore() throws SecurityException
/*     */     {
/* 132 */       initDelegate();
/* 133 */       return this.delegate.getKeyStore();
/*     */     }
/*     */ 
/*     */     public KeyManagerFactory getKeyManagerFactory() throws SecurityException
/*     */     {
/* 138 */       initDelegate();
/* 139 */       return this.delegate.getKeyManagerFactory();
/*     */     }
/*     */ 
/*     */     public KeyStore getTrustStore() throws SecurityException
/*     */     {
/* 144 */       initDelegate();
/* 145 */       return this.delegate.getTrustStore();
/*     */     }
/*     */ 
/*     */     public TrustManagerFactory getTrustManagerFactory() throws SecurityException
/*     */     {
/* 150 */       initDelegate();
/* 151 */       return this.delegate.getTrustManagerFactory();
/*     */     }
/*     */ 
/*     */     public String getSecurityDomain()
/*     */     {
/* 156 */       initDelegate();
/* 157 */       return this.delegate.getSecurityDomain();
/*     */     }
/*     */ 
/*     */     public boolean isValid(Principal principal, Object credential)
/*     */     {
/* 162 */       return isValid(principal, credential, null);
/*     */     }
/*     */ 
/*     */     public boolean isValid(Principal principal, Object credential, Subject activeSubject)
/*     */     {
/* 168 */       initDelegate();
/* 169 */       return this.delegate.isValid(principal, credential, activeSubject);
/*     */     }
/*     */ 
/*     */     public boolean isValid(MessageInfo messageInfo, Subject activeSubject, String layer)
/*     */     {
/* 174 */       initDelegate();
/* 175 */       return this.delegate.isValid(messageInfo, activeSubject, layer);
/*     */     }
/*     */ 
/*     */     public Subject getActiveSubject()
/*     */     {
/* 180 */       initDelegate();
/* 181 */       return this.delegate.getActiveSubject();
/*     */     }
/*     */ 
/*     */     public Principal getPrincipal(Principal principal)
/*     */     {
/* 186 */       initDelegate();
/* 187 */       return this.delegate.getPrincipal(principal);
/*     */     }
/*     */ 
/*     */     public Principal getTargetPrincipal(Principal anotherDomainPrincipal, Map contextMap)
/*     */     {
/* 195 */       throw new RuntimeException("Not implemented yet");
/*     */     }
/*     */ 
/*     */     public boolean doesUserHaveRole(Principal principal, Set roles)
/*     */     {
/* 200 */       initDelegate();
/* 201 */       return this.delegate.doesUserHaveRole(principal, roles);
/*     */     }
/*     */ 
/*     */     public Set getUserRoles(Principal principal)
/*     */     {
/* 206 */       initDelegate();
/* 207 */       return this.delegate.getUserRoles(principal);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.propertyeditor.SecurityDomainEditor
 * JD-Core Version:    0.6.0
 */