/*    */ package org.jboss.security.plugins.authorization;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   static ClassLoader getContextClassLoader()
/*    */     throws PrivilegedActionException
/*    */   {
/* 40 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction()
/*    */     {
/*    */       public Object run()
/*    */       {
/* 44 */         return Thread.currentThread().getContextClassLoader();
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static Class loadClass(String name) throws PrivilegedActionException {
/* 51 */     return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(name)
/*    */     {
/*    */       public Object run() throws PrivilegedActionException
/*    */       {
/*    */         try
/*    */         {
/* 57 */           return SecurityActions.getContextClassLoader().loadClass(this.val$name);
/*    */         }
/*    */         catch (Exception e) {
/*    */         }
/* 61 */         throw new PrivilegedActionException(e);
/*    */       }
/*    */     });
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.authorization.SecurityActions
 * JD-Core Version:    0.6.0
 */