/*     */ package org.jboss.security.plugins.authorization;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.authorization.AuthorizationContext;
/*     */ import org.jboss.security.authorization.AuthorizationException;
/*     */ import org.jboss.security.authorization.AuthorizationModule;
/*     */ import org.jboss.security.authorization.Resource;
/*     */ import org.jboss.security.authorization.ResourceType;
/*     */ import org.jboss.security.authorization.config.AuthorizationModuleEntry;
/*     */ import org.jboss.security.authorization.modules.DelegatingAuthorizationModule;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.AuthorizationInfo;
/*     */ import org.jboss.security.config.ControlFlag;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ 
/*     */ public class JBossAuthorizationContext extends AuthorizationContext
/*     */ {
/*  65 */   private static Logger log = Logger.getLogger(JBossAuthorizationContext.class);
/*  66 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  69 */   private ApplicationPolicy applicationPolicy = null;
/*     */ 
/*     */   public JBossAuthorizationContext(String name, Subject subject, CallbackHandler handler)
/*     */   {
/*  74 */     this.securityDomainName = name;
/*  75 */     this.authenticatedSubject = subject;
/*  76 */     this.callbackHandler = handler;
/*     */   }
/*     */ 
/*     */   public void setApplicationPolicy(ApplicationPolicy aPolicy)
/*     */   {
/*  87 */     if (aPolicy == null)
/*  88 */       throw new IllegalArgumentException("Application Policy is null:domain=" + this.securityDomainName);
/*  89 */     AuthorizationInfo authzInfo = aPolicy.getAuthorizationInfo();
/*  90 */     if (authzInfo == null)
/*  91 */       throw new IllegalArgumentException("Application Policy has no AuthorizationInfo");
/*  92 */     if (!authzInfo.getName().equals(this.securityDomainName)) {
/*  93 */       throw new IllegalArgumentException("Application Policy ->AuthorizationInfo:" + authzInfo.getName() + " does not match required domain name=" + this.securityDomainName);
/*     */     }
/*  95 */     this.applicationPolicy = aPolicy;
/*     */   }
/*     */ 
/*     */   public int authorize(Resource resource)
/*     */     throws AuthorizationException
/*     */   {
/*     */     try
/*     */     {
/* 110 */       initializeModules(resource);
/*     */     }
/*     */     catch (PrivilegedActionException e1)
/*     */     {
/* 114 */       throw new RuntimeException(e1);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 119 */       AccessController.doPrivileged(new PrivilegedExceptionAction(resource)
/*     */       {
/*     */         public Object run() throws AuthorizationException
/*     */         {
/* 123 */           int result = JBossAuthorizationContext.this.invokeAuthorize(this.val$resource);
/* 124 */           if (result == 1)
/* 125 */             JBossAuthorizationContext.this.invokeCommit();
/* 126 */           if (result == -1)
/*     */           {
/* 128 */             JBossAuthorizationContext.this.invokeAbort();
/* 129 */             throw new AuthorizationException("Denied");
/*     */           }
/* 131 */           return null;
/*     */         }
/*     */       });
/*     */     }
/*     */     catch (PrivilegedActionException e) {
/* 137 */       Exception exc = e.getException();
/* 138 */       if (this.trace)
/* 139 */         log.trace("Error in authorize:", exc);
/* 140 */       invokeAbort();
/* 141 */       throw ((AuthorizationException)exc);
/*     */     }
/* 143 */     return 1;
/*     */   }
/*     */ 
/*     */   private void initializeModules(Resource resource)
/*     */     throws PrivilegedActionException
/*     */   {
/* 150 */     AuthorizationInfo authzInfo = getAuthorizationInfo(this.securityDomainName, resource);
/* 151 */     if (authzInfo == null)
/* 152 */       throw new IllegalStateException("Authorization Info is null");
/* 153 */     AuthorizationModuleEntry[] entries = authzInfo.getAuthorizationModuleEntry();
/* 154 */     int len = entries != null ? entries.length : 0;
/* 155 */     for (int i = 0; i < len; i++)
/*     */     {
/* 157 */       AuthorizationModuleEntry entry = entries[i];
/* 158 */       ControlFlag flag = entry.getControlFlag();
/* 159 */       if (flag == null)
/*     */       {
/* 161 */         if (this.trace)
/* 162 */           log.trace("Null Control flag for entry:" + entry + ". Defaults to REQUIRED!");
/* 163 */         flag = ControlFlag.REQUIRED;
/*     */       }
/* 166 */       else if (this.trace) {
/* 167 */         log.trace("Control flag for entry:" + entry + "is:[" + flag + "]");
/*     */       }
/* 169 */       this.controlFlags.add(flag);
/* 170 */       this.modules.add(instantiateModule(entry.getPolicyModuleName(), entry.getOptions()));
/*     */     }
/*     */   }
/*     */ 
/*     */   private int invokeAuthorize(Resource resource)
/*     */     throws AuthorizationException
/*     */   {
/* 178 */     boolean encounteredRequiredError = false;
/* 179 */     boolean encounteredOptionalError = false;
/* 180 */     AuthorizationException moduleException = null;
/* 181 */     int overallDecision = -1;
/*     */ 
/* 183 */     int length = this.modules.size();
/* 184 */     for (int i = 0; i < length; i++)
/*     */     {
/* 186 */       AuthorizationModule module = (AuthorizationModule)this.modules.get(i);
/* 187 */       ControlFlag flag = (ControlFlag)this.controlFlags.get(i);
/* 188 */       int decision = -1;
/*     */       try
/*     */       {
/* 191 */         decision = module.authorize(resource);
/*     */       }
/*     */       catch (Exception ae)
/*     */       {
/* 195 */         decision = -1;
/* 196 */         if (moduleException == null) {
/* 197 */           moduleException = new AuthorizationException(ae.getMessage());
/*     */         }
/*     */       }
/* 200 */       if (decision == 1)
/*     */       {
/* 202 */         overallDecision = 1;
/*     */ 
/* 204 */         if ((flag == ControlFlag.SUFFICIENT) && (!encounteredRequiredError)) {
/* 205 */           return 1;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 210 */         if (flag == ControlFlag.REQUISITE)
/*     */         {
/* 212 */           if (this.trace)
/* 213 */             log.trace("REQUISITE failed for " + module);
/* 214 */           if (moduleException == null)
/* 215 */             moduleException = new AuthorizationException("Authorization failed");
/*     */           else {
/* 217 */             throw moduleException;
/*     */           }
/*     */         }
/* 220 */         if (flag == ControlFlag.REQUIRED)
/*     */         {
/* 222 */           if (this.trace)
/* 223 */             log.trace("REQUIRED failed for " + module);
/* 224 */           if (!encounteredRequiredError)
/* 225 */             encounteredRequiredError = true;
/*     */         }
/* 227 */         if (flag == ControlFlag.OPTIONAL) {
/* 228 */           encounteredOptionalError = true;
/*     */         }
/*     */       }
/*     */     }
/* 232 */     String msg = getAdditionalErrorMessage(moduleException);
/* 233 */     if (encounteredRequiredError)
/* 234 */       throw new AuthorizationException("Authorization Failed:" + msg);
/* 235 */     if ((overallDecision == -1) && (encounteredOptionalError))
/* 236 */       throw new AuthorizationException("Authorization Failed:" + msg);
/* 237 */     if (overallDecision == -1)
/* 238 */       throw new AuthorizationException("Authorization Failed:No modules active.");
/* 239 */     return 1;
/*     */   }
/*     */ 
/*     */   private void invokeCommit()
/*     */     throws AuthorizationException
/*     */   {
/* 245 */     int length = this.modules.size();
/* 246 */     for (int i = 0; i < length; i++)
/*     */     {
/* 248 */       AuthorizationModule module = (AuthorizationModule)this.modules.get(i);
/* 249 */       boolean bool = module.commit();
/* 250 */       if (!bool)
/* 251 */         throw new AuthorizationException("commit on modules failed");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void invokeAbort()
/*     */     throws AuthorizationException
/*     */   {
/* 258 */     int length = this.modules.size();
/* 259 */     for (int i = 0; i < length; i++)
/*     */     {
/* 261 */       AuthorizationModule module = (AuthorizationModule)this.modules.get(i);
/* 262 */       boolean bool = module.abort();
/* 263 */       if (!bool)
/* 264 */         throw new AuthorizationException("abort on modules failed");
/*     */     }
/*     */   }
/*     */ 
/*     */   private AuthorizationModule instantiateModule(String name, Map<String, Object> map)
/*     */     throws PrivilegedActionException
/*     */   {
/* 271 */     AuthorizationModule am = null;
/* 272 */     ClassLoader tcl = SecurityActions.getContextClassLoader();
/*     */     try
/*     */     {
/* 275 */       Class clazz = tcl.loadClass(name);
/* 276 */       am = (AuthorizationModule)clazz.newInstance();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 280 */       log.debug("Error instantiating AuthorizationModule:", e);
/*     */     }
/* 282 */     if (am == null) {
/* 283 */       throw new IllegalStateException("AuthorizationModule has not been instantiated");
/*     */     }
/* 285 */     am.initialize(this.authenticatedSubject, this.callbackHandler, this.sharedState, map);
/*     */ 
/* 287 */     return am;
/*     */   }
/*     */ 
/*     */   private AuthorizationInfo getAuthorizationInfo(String domainName, Resource resource)
/*     */   {
/* 292 */     ResourceType layer = resource.getLayer();
/*     */ 
/* 295 */     if (this.applicationPolicy != null) {
/* 296 */       return this.applicationPolicy.getAuthorizationInfo();
/*     */     }
/* 298 */     ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(domainName);
/*     */ 
/* 300 */     if (aPolicy == null)
/*     */     {
/* 302 */       if (this.trace) {
/* 303 */         log.trace("Application Policy not obtained for domain=" + domainName + ". Trying to obtain the App policy for the default domain of the layer:");
/*     */       }
/* 305 */       if (layer == ResourceType.EJB) {
/* 306 */         aPolicy = SecurityConfiguration.getApplicationPolicy("jboss-ejb-policy");
/*     */       }
/* 308 */       else if (layer == ResourceType.WEB)
/* 309 */         aPolicy = SecurityConfiguration.getApplicationPolicy("jboss-web-policy");
/*     */     }
/* 311 */     if (aPolicy == null) {
/* 312 */       throw new IllegalStateException("Application Policy is null for domain:" + domainName);
/*     */     }
/* 314 */     AuthorizationInfo ai = aPolicy.getAuthorizationInfo();
/* 315 */     if (ai == null) {
/* 316 */       return getAuthorizationInfo(layer);
/*     */     }
/* 318 */     return aPolicy.getAuthorizationInfo();
/*     */   }
/*     */ 
/*     */   private AuthorizationInfo getAuthorizationInfo(ResourceType layer)
/*     */   {
/* 323 */     AuthorizationInfo ai = null;
/*     */ 
/* 325 */     if (layer == ResourceType.EJB) {
/* 326 */       ai = SecurityConfiguration.getApplicationPolicy("jboss-ejb-policy").getAuthorizationInfo();
/*     */     }
/* 328 */     else if (layer == ResourceType.WEB) {
/* 329 */       ai = SecurityConfiguration.getApplicationPolicy("jboss-web-policy").getAuthorizationInfo();
/*     */     }
/*     */     else {
/* 332 */       if (log.isTraceEnabled())
/* 333 */         log.trace("AuthorizationInfo not found. Providing default authorization info");
/* 334 */       ai = new AuthorizationInfo("other");
/* 335 */       ai.add(new AuthorizationModuleEntry(DelegatingAuthorizationModule.class.getName()));
/*     */     }
/* 337 */     return ai;
/*     */   }
/*     */ 
/*     */   private String getAdditionalErrorMessage(Exception e)
/*     */   {
/* 342 */     StringBuilder msg = new StringBuilder(" ");
/* 343 */     if (e != null)
/* 344 */       msg.append(e.getLocalizedMessage());
/* 345 */     return msg.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.authorization.JBossAuthorizationContext
 * JD-Core Version:    0.6.0
 */