/*     */ package org.jboss.security.plugins.auth;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginContext;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ class SubjectActions
/*     */ {
/*     */   static Subject getActiveSubject()
/*     */     throws PrivilegedActionException
/*     */   {
/* 290 */     Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
/* 291 */     return subject;
/*     */   }
/*     */ 
/*     */   static void copySubject(Subject fromSubject, Subject toSubject) {
/* 295 */     copySubject(fromSubject, toSubject, false);
/*     */   }
/*     */ 
/*     */   static void copySubject(Subject fromSubject, Subject toSubject, boolean setReadOnly) {
/* 299 */     CopySubjectAction action = new CopySubjectAction(fromSubject, toSubject, setReadOnly);
/* 300 */     if (System.getSecurityManager() != null)
/* 301 */       AccessController.doPrivileged(action);
/*     */     else
/* 303 */       action.run();
/*     */   }
/*     */ 
/*     */   static void copySubject(Subject fromSubject, Subject toSubject, boolean setReadOnly, boolean deepCopy)
/*     */   {
/* 309 */     CopySubjectAction action = new CopySubjectAction(fromSubject, toSubject, setReadOnly);
/* 310 */     action.setDeepCopy(deepCopy);
/* 311 */     if (System.getSecurityManager() != null)
/* 312 */       AccessController.doPrivileged(action);
/*     */     else
/* 314 */       action.run();
/*     */   }
/*     */ 
/*     */   static LoginContext createLoginContext(String securityDomain, Subject subject, CallbackHandler handler) throws LoginException {
/* 321 */     LoginContextAction action = new LoginContextAction(securityDomain, subject, handler);
/*     */     Exception ex;
/*     */     try {
/* 324 */       LoginContext lc = (LoginContext)AccessController.doPrivileged(action);
/* 325 */       return lc;
/*     */     }
/*     */     catch (PrivilegedActionException e)
/*     */     {
/* 329 */       ex = e.getException();
/* 330 */       if ((ex instanceof LoginException))
/* 331 */         throw ((LoginException)ex);
/*     */     }
/* 333 */     throw new LoginException(ex.getMessage());
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 339 */     ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
/* 340 */     return loader;
/*     */   }
/*     */ 
/*     */   static Object setContextInfo(Object key, Object value)
/*     */   {
/* 345 */     SetContextInfoAction action = new SetContextInfoAction(key, value);
/* 346 */     Object prevInfo = AccessController.doPrivileged(action);
/* 347 */     return prevInfo;
/*     */   }
/*     */ 
/*     */   static String toString(Subject subject)
/*     */   {
/* 352 */     ToStringSubjectAction action = new ToStringSubjectAction(subject);
/* 353 */     String info = (String)AccessController.doPrivileged(action);
/* 354 */     return info;
/*     */   }
/*     */ 
/*     */   static abstract interface PrincipalInfoAction
/*     */   {
/* 206 */     public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject, String securityDomain)
/*     */       {
/* 211 */         AccessController.doPrivileged(new PrivilegedAction(principal, credential, subject, securityDomain)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 217 */             SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 218 */             if (sc == null)
/*     */             {
/*     */               try
/*     */               {
/* 222 */                 sc = SecurityContextFactory.createSecurityContext(this.val$principal, this.val$credential, this.val$subject, this.val$securityDomain);
/*     */               }
/*     */               catch (Exception e)
/*     */               {
/* 227 */                 throw new RuntimeException(e);
/*     */               }
/*     */             }
/* 230 */             SecurityContextAssociation.setSecurityContext(sc);
/* 231 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void pop() {
/* 238 */         AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/* 244 */             SecurityContextAssociation.clearSecurityContext();
/* 245 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 206 */     };
/*     */ 
/* 252 */     public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction()
/*     */     {
/*     */       public void push(Principal principal, Object credential, Subject subject, String securityDomain)
/*     */       {
/* 258 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 259 */         if (sc == null)
/*     */         {
/*     */           try
/*     */           {
/* 263 */             sc = SecurityContextFactory.createSecurityContext(principal, credential, subject, securityDomain);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 268 */             throw new RuntimeException(e);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 273 */           sc.getUtil().createSubjectInfo(principal, credential, subject);
/*     */         }
/* 275 */         SecurityContextAssociation.setSecurityContext(sc);
/*     */       }
/*     */ 
/*     */       public void pop()
/*     */       {
/* 280 */         SecurityContextAssociation.clearSecurityContext();
/*     */       }
/* 252 */     };
/*     */ 
/*     */     public abstract void push(Principal paramPrincipal, Object paramObject, Subject paramSubject, String paramString);
/*     */ 
/*     */     public abstract void pop();
/*     */   }
/*     */ 
/*     */   private static class SetContextInfoAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Object key;
/*     */     Object value;
/*     */ 
/*     */     SetContextInfoAction(Object key, Object value)
/*     */     {
/* 189 */       this.key = key;
/* 190 */       this.value = value;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 195 */       SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 196 */       if (sc != null)
/*     */       {
/* 198 */         sc.getData().put(this.key.toString(), this.value);
/*     */       }
/* 200 */       return SecurityAssociation.setContextInfo(this.key, this.value);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetTCLAction
/*     */     implements PrivilegedAction
/*     */   {
/* 175 */     static PrivilegedAction ACTION = new GetTCLAction();
/*     */ 
/*     */     public Object run() {
/* 178 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 179 */       return loader;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class LoginContextAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     String securityDomain;
/*     */     Subject subject;
/*     */     CallbackHandler handler;
/*     */ 
/*     */     LoginContextAction(String securityDomain, Subject subject, CallbackHandler handler)
/*     */     {
/* 162 */       this.securityDomain = securityDomain;
/* 163 */       this.subject = subject;
/* 164 */       this.handler = handler;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception {
/* 168 */       LoginContext lc = new LoginContext(this.securityDomain, this.subject, this.handler);
/* 169 */       return lc;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class CopySubjectAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Subject fromSubject;
/*     */     Subject toSubject;
/*     */     boolean setReadOnly;
/*     */     boolean deepCopy;
/*     */ 
/*     */     CopySubjectAction(Subject fromSubject, Subject toSubject, boolean setReadOnly)
/*     */     {
/* 100 */       this.fromSubject = fromSubject;
/* 101 */       this.toSubject = toSubject;
/* 102 */       this.setReadOnly = setReadOnly;
/*     */     }
/*     */ 
/*     */     public void setDeepCopy(boolean flag) {
/* 106 */       this.deepCopy = flag;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 111 */       Set principals = this.fromSubject.getPrincipals();
/* 112 */       Set principals2 = this.toSubject.getPrincipals();
/* 113 */       Iterator iter = principals.iterator();
/* 114 */       while (iter.hasNext())
/* 115 */         principals2.add(getCloneIfNeeded(iter.next()));
/* 116 */       Set privateCreds = this.fromSubject.getPrivateCredentials();
/* 117 */       Set privateCreds2 = this.toSubject.getPrivateCredentials();
/* 118 */       iter = privateCreds.iterator();
/* 119 */       while (iter.hasNext())
/* 120 */         privateCreds2.add(getCloneIfNeeded(iter.next()));
/* 121 */       Set publicCreds = this.fromSubject.getPublicCredentials();
/* 122 */       Set publicCreds2 = this.toSubject.getPublicCredentials();
/* 123 */       iter = publicCreds.iterator();
/* 124 */       while (iter.hasNext())
/* 125 */         publicCreds2.add(getCloneIfNeeded(iter.next()));
/* 126 */       if (this.setReadOnly == true)
/* 127 */         this.toSubject.setReadOnly();
/* 128 */       return null;
/*     */     }
/*     */ 
/*     */     private Object getCloneIfNeeded(Object obj)
/*     */     {
/* 135 */       Object clonedObject = null;
/* 136 */       if ((this.deepCopy) && ((obj instanceof Cloneable)))
/*     */       {
/* 138 */         Class clazz = obj.getClass();
/*     */         try
/*     */         {
/* 141 */           Method cloneMethod = clazz.getMethod("clone", null);
/* 142 */           clonedObject = cloneMethod.invoke(obj, null);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */       }
/* 148 */       if (clonedObject == null)
/* 149 */         clonedObject = obj;
/* 150 */       return clonedObject;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetSubjectAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*  84 */     static PrivilegedExceptionAction ACTION = new GetSubjectAction();
/*     */ 
/*     */     public Object run() throws PolicyContextException {
/*  87 */       return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ToStringSubjectAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Subject subject;
/*     */ 
/*     */     ToStringSubjectAction(Subject subject)
/*     */     {
/*  58 */       this.subject = subject;
/*     */     }
/*     */ 
/*     */     public Object run() {
/*  62 */       StringBuffer tmp = new StringBuffer();
/*  63 */       tmp.append("Subject(");
/*  64 */       tmp.append(System.identityHashCode(this.subject));
/*  65 */       tmp.append(").principals=");
/*  66 */       Iterator principals = this.subject.getPrincipals().iterator();
/*  67 */       while (principals.hasNext())
/*     */       {
/*  69 */         Object p = principals.next();
/*  70 */         Class c = p.getClass();
/*  71 */         tmp.append(c.getName());
/*  72 */         tmp.append('@');
/*  73 */         tmp.append(System.identityHashCode(c));
/*  74 */         tmp.append('(');
/*  75 */         tmp.append(p);
/*  76 */         tmp.append(')');
/*     */       }
/*  78 */       return tmp.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.auth.SubjectActions
 * JD-Core Version:    0.6.0
 */