/*     */ package org.jboss.security.plugins.audit;
/*     */ 
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.util.Arrays;
/*     */ import java.util.List;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.audit.AuditContext;
/*     */ import org.jboss.security.audit.AuditEvent;
/*     */ import org.jboss.security.audit.AuditManager;
/*     */ import org.jboss.security.audit.AuditProvider;
/*     */ import org.jboss.security.audit.config.AuditProviderEntry;
/*     */ import org.jboss.security.audit.providers.LogAuditProvider;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.AuditInfo;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ 
/*     */ public class JBossAuditManager
/*     */   implements AuditManager
/*     */ {
/*  33 */   private static Logger log = Logger.getLogger(JBossAuditManager.class);
/*     */ 
/*  35 */   private static ConcurrentHashMap<String, AuditContext> contexts = new ConcurrentHashMap();
/*     */ 
/*  37 */   private static AuditContext defaultContext = null;
/*     */   private String securityDomain;
/*     */ 
/*     */   public JBossAuditManager(String secDomain)
/*     */   {
/*  49 */     this.securityDomain = secDomain;
/*     */   }
/*     */ 
/*     */   public AuditContext getAuditContext() throws PrivilegedActionException
/*     */   {
/*  54 */     AuditContext ac = (AuditContext)contexts.get(this.securityDomain);
/*  55 */     if (ac == null)
/*     */     {
/*  57 */       ac = new JBossAuditContext(this.securityDomain);
/*  58 */       ApplicationPolicy ap = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
/*  59 */       if (ap != null)
/*     */       {
/*  61 */         AuditInfo ai = ap.getAuditInfo();
/*  62 */         if (ai != null)
/*     */         {
/*  64 */           AuditProviderEntry[] apeArr = ai.getAuditProviderEntry();
/*  65 */           List list = Arrays.asList(apeArr);
/*  66 */           for (AuditProviderEntry ape : list)
/*     */           {
/*  68 */             String pname = ape.getName();
/*     */             try
/*     */             {
/*  71 */               ac.addProvider((AuditProvider)SecurityActions.loadClass(pname).newInstance());
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/*  75 */               throw new RuntimeException(e);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*  81 */     if (ac == null)
/*     */     {
/*  83 */       if (log.isTraceEnabled()) {
/*  84 */         log.trace("No audit Context found for " + this.securityDomain + " ; defaulting to" + " audit context for other");
/*     */       }
/*  86 */       ac = defaultContext;
/*     */     }
/*  88 */     return ac;
/*     */   }
/*     */ 
/*     */   public static AuditContext getAuditContext(String securityDomain)
/*     */   {
/*  93 */     AuditContext ac = (AuditContext)contexts.get(securityDomain);
/*  94 */     if (ac == null)
/*  95 */       ac = defaultContext;
/*  96 */     return ac;
/*     */   }
/*     */ 
/*     */   public static void addAuditContext(String securityDomain, AuditContext ac)
/*     */   {
/* 101 */     contexts.put(securityDomain, ac);
/*     */   }
/*     */ 
/*     */   public void audit(AuditEvent ae)
/*     */   {
/* 106 */     AuditContext ac = null;
/*     */     try
/*     */     {
/* 109 */       ac = getAuditContext();
/*     */     }
/*     */     catch (PrivilegedActionException e)
/*     */     {
/* 113 */       throw new RuntimeException(e);
/*     */     }
/* 115 */     ac.audit(ae);
/*     */ 
/* 117 */     if (ac != defaultContext)
/*     */     {
/* 119 */       defaultContext.audit(ae);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 125 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  41 */     defaultContext = new JBossAuditContext("Default_Context");
/*  42 */     defaultContext.addProvider(new LogAuditProvider());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.audit.JBossAuditManager
 * JD-Core Version:    0.6.0
 */