/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.io.CharArrayWriter;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.RandomAccessFile;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class TmpFilePassword
/*     */ {
/*  47 */   private static Logger log = Logger.getLogger(TmpFilePassword.class);
/*     */   private File passwordFile;
/*     */ 
/*     */   public TmpFilePassword(String file)
/*     */   {
/*  52 */     this.passwordFile = new File(file);
/*     */   }
/*     */ 
/*     */   public char[] toCharArray() throws IOException
/*     */   {
/*     */     while (true) {
/*  58 */       if (!this.passwordFile.exists())
/*     */       {
/*  60 */         log.info("Waiting for password file: " + this.passwordFile.getAbsolutePath());
/*     */         try
/*     */         {
/*  63 */           Thread.sleep(10000L);
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/*  67 */           log.info("Exiting wait on InterruptedException");
/*     */         }
/*     */       }
/*     */     }
/*  71 */     FileInputStream fis = new FileInputStream(this.passwordFile);
/*  72 */     CharArrayWriter writer = new CharArrayWriter();
/*     */     int b;
/*  74 */     while ((b = fis.read()) >= 0)
/*     */     {
/*  76 */       if ((b == 13) || (b == 10))
/*     */         continue;
/*  78 */       writer.write(b);
/*     */     }
/*  80 */     fis.close();
/*  81 */     char[] password = writer.toCharArray();
/*  82 */     writer.reset();
/*  83 */     for (int n = 0; n < password.length; n++) {
/*  84 */       writer.write(0);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  89 */       RandomAccessFile raf = new RandomAccessFile(this.passwordFile, "rws");
/*  90 */       for (int i = 0; i < 10; i++)
/*     */       {
/*  92 */         raf.seek(0L);
/*  93 */         for (int j = 0; j < password.length; j++)
/*  94 */           raf.write(j);
/*     */       }
/*  96 */       raf.close();
/*  97 */       if (!this.passwordFile.delete())
/*  98 */         log.warn("Was not able to delete the password file");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 102 */       log.warn("Failed to zero the password file", e);
/*     */     }
/* 104 */     return password;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.TmpFilePassword
 * JD-Core Version:    0.6.0
 */