/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import javax.naming.InvalidNameException;
/*     */ import javax.naming.NamingException;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.SubjectSecurityManager;
/*     */ import org.jboss.security.audit.AuditManager;
/*     */ import org.jboss.security.identitytrust.IdentityTrustManager;
/*     */ import org.jboss.security.mapping.MappingManager;
/*     */ import org.jboss.util.CachePolicy;
/*     */ 
/*     */ public class SecurityDomainContext
/*     */ {
/*     */   static final String ACTIVE_SUBJECT = "subject";
/*     */   static final String AUTHENTICATION_MGR = "authenticationMgr";
/*     */   static final String SECURITY_MGR = "securityMgr";
/*     */   static final String REALM_MAPPING = "realmMapping";
/*     */   static final String AUTHORIZATION_MGR = "authorizationMgr";
/*     */   static final String AUDIT_MGR = "auditMgr";
/*     */   static final String MAPPING_MGR = "mappingMgr";
/*     */   static final String IDENTITY_TRUST_MGR = "identityTrustMgr";
/*     */   static final String AUTH_CACHE = "authenticationCache";
/*     */   static final String DOMAIN_CONTEXT = "domainContext";
/*     */   AuthenticationManager securityMgr;
/*     */   AuthorizationManager authorizationMgr;
/*     */   CachePolicy authenticationCache;
/*     */   AuditManager auditMgr;
/*     */   MappingManager mappingMgr;
/*     */   IdentityTrustManager identityTrustMgr;
/*     */ 
/*     */   public SecurityDomainContext(AuthenticationManager securityMgr, CachePolicy authenticationCache)
/*     */   {
/*  67 */     this.securityMgr = securityMgr;
/*  68 */     this.authenticationCache = authenticationCache;
/*     */   }
/*     */ 
/*     */   public Object lookup(String name) throws NamingException
/*     */   {
/*  73 */     Object binding = null;
/*  74 */     if ((name == null) || (name.length() == 0)) {
/*  75 */       throw new InvalidNameException("name cannot be null or empty");
/*     */     }
/*  77 */     if (name.equals("subject"))
/*  78 */       binding = getSubject();
/*  79 */     else if ((name.equals("authenticationMgr")) || (name.equals("securityMgr")))
/*  80 */       binding = this.securityMgr;
/*  81 */     else if (name.equals("realmMapping"))
/*  82 */       binding = getRealmMapping();
/*  83 */     else if (name.equals("authorizationMgr"))
/*  84 */       binding = getAuthorizationManager();
/*  85 */     else if (name.equals("auditMgr"))
/*  86 */       binding = getAuditMgr();
/*  87 */     else if (name.equals("mappingMgr"))
/*  88 */       binding = getMappingMgr();
/*  89 */     else if (name.equals("identityTrustMgr"))
/*  90 */       binding = getIdentityTrustMgr();
/*  91 */     else if (name.equals("authenticationCache"))
/*  92 */       binding = this.authenticationCache;
/*  93 */     else if (name.equals("domainContext")) {
/*  94 */       binding = this;
/*     */     }
/*  96 */     return binding;
/*     */   }
/*     */ 
/*     */   public Subject getSubject() {
/* 100 */     Subject subject = null;
/* 101 */     if ((this.securityMgr instanceof SubjectSecurityManager))
/*     */     {
/* 103 */       subject = ((SubjectSecurityManager)this.securityMgr).getActiveSubject();
/*     */     }
/* 105 */     return subject;
/*     */   }
/*     */ 
/*     */   public AuthenticationManager getSecurityManager() {
/* 109 */     return this.securityMgr;
/*     */   }
/*     */ 
/*     */   public RealmMapping getRealmMapping() {
/* 113 */     RealmMapping realmMapping = null;
/* 114 */     if ((this.authorizationMgr != null) && ((this.authorizationMgr instanceof RealmMapping)))
/*     */     {
/* 116 */       realmMapping = (RealmMapping)this.authorizationMgr;
/*     */     }
/* 119 */     else if ((this.securityMgr instanceof RealmMapping))
/*     */     {
/* 121 */       realmMapping = (RealmMapping)this.securityMgr;
/*     */     }
/* 123 */     return realmMapping;
/*     */   }
/*     */ 
/*     */   public void setAuthenticationManager(AuthenticationManager aum)
/*     */   {
/* 128 */     this.securityMgr = aum;
/*     */   }
/*     */ 
/*     */   public void setAuthorizationManager(AuthorizationManager am)
/*     */   {
/* 133 */     this.authorizationMgr = am;
/*     */   }
/*     */ 
/*     */   public AuthorizationManager getAuthorizationManager()
/*     */   {
/* 138 */     return this.authorizationMgr;
/*     */   }
/*     */ 
/*     */   public void setAuthenticationCache(CachePolicy cp)
/*     */   {
/* 143 */     this.authenticationCache = cp;
/*     */   }
/*     */ 
/*     */   public CachePolicy getAuthenticationCache()
/*     */   {
/* 148 */     return this.authenticationCache;
/*     */   }
/*     */ 
/*     */   public AuditManager getAuditMgr()
/*     */   {
/* 153 */     return this.auditMgr;
/*     */   }
/*     */ 
/*     */   public void setAuditMgr(AuditManager auditMgr)
/*     */   {
/* 158 */     this.auditMgr = auditMgr;
/*     */   }
/*     */ 
/*     */   public MappingManager getMappingMgr()
/*     */   {
/* 163 */     return this.mappingMgr;
/*     */   }
/*     */ 
/*     */   public void setMappingMgr(MappingManager mappingMgr)
/*     */   {
/* 168 */     this.mappingMgr = mappingMgr;
/*     */   }
/*     */ 
/*     */   public IdentityTrustManager getIdentityTrustMgr()
/*     */   {
/* 173 */     return this.identityTrustMgr;
/*     */   }
/*     */ 
/*     */   public void setIdentityTrustMgr(IdentityTrustManager identityTrustMgr)
/*     */   {
/* 178 */     this.identityTrustMgr = identityTrustMgr;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.SecurityDomainContext
 * JD-Core Version:    0.6.0
 */