/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.util.Stack;
/*     */ import javax.management.JMException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.security.auth.login.Configuration;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class SecurityConfig extends ServiceMBeanSupport
/*     */   implements SecurityConfigMBean
/*     */ {
/*     */   private String loginConfigName;
/*  50 */   private Stack loginConfigStack = new Stack();
/*     */ 
/*     */   public String getName()
/*     */   {
/*  69 */     return "SecurityIntialization";
/*     */   }
/*     */ 
/*     */   public String getLoginConfig()
/*     */   {
/*  76 */     return this.loginConfigName;
/*     */   }
/*     */ 
/*     */   public void setLoginConfig(String name)
/*     */     throws MalformedObjectNameException
/*     */   {
/*  83 */     this.loginConfigName = name;
/*     */   }
/*     */ 
/*     */   public void startService()
/*     */     throws Exception
/*     */   {
/*  91 */     pushLoginConfig(this.loginConfigName);
/*     */   }
/*     */ 
/*     */   public void stopService()
/*     */     throws Exception
/*     */   {
/*  99 */     if (!this.loginConfigStack.empty())
/* 100 */       popLoginConfig();
/*     */   }
/*     */ 
/*     */   public synchronized void pushLoginConfig(String objectName)
/*     */     throws JMException, MalformedObjectNameException
/*     */   {
/* 110 */     ObjectName name = new ObjectName(objectName);
/* 111 */     Configuration prevConfig = null;
/* 112 */     if (!this.loginConfigStack.empty())
/*     */     {
/* 114 */       ConfigInfo prevInfo = (ConfigInfo)this.loginConfigStack.peek();
/* 115 */       prevConfig = prevInfo.config;
/*     */     }
/*     */ 
/* 118 */     ConfigInfo info = installConfig(name, prevConfig);
/* 119 */     this.loginConfigStack.push(info);
/*     */   }
/*     */ 
/*     */   public synchronized void popLoginConfig()
/*     */     throws JMException
/*     */   {
/* 128 */     ConfigInfo info = (ConfigInfo)this.loginConfigStack.pop();
/* 129 */     Configuration prevConfig = null;
/* 130 */     if (!this.loginConfigStack.empty())
/*     */     {
/* 132 */       ConfigInfo prevInfo = (ConfigInfo)this.loginConfigStack.peek();
/* 133 */       prevConfig = prevInfo.config;
/*     */     }
/*     */ 
/* 136 */     installConfig(info.name, prevConfig);
/*     */   }
/*     */ 
/*     */   private ConfigInfo installConfig(ObjectName name, Configuration prevConfig)
/*     */     throws JMException
/*     */   {
/* 147 */     MBeanServer server = super.getServer();
/* 148 */     Object[] args = { prevConfig };
/* 149 */     String[] signature = { "javax.security.auth.login.Configuration" };
/* 150 */     Configuration config = (Configuration)server.invoke(name, "getConfiguration", args, signature);
/*     */ 
/* 152 */     Configuration.setConfiguration(config);
/* 153 */     ConfigInfo info = new ConfigInfo(name, config);
/* 154 */     this.log.debug("Installed JAAS Configuration service=" + name + ", config=" + config);
/* 155 */     return info;
/*     */   }
/*     */ 
/*     */   static class ConfigInfo
/*     */   {
/*     */     ObjectName name;
/*     */     Configuration config;
/*     */ 
/*     */     ConfigInfo(ObjectName name, Configuration config)
/*     */     {
/*  58 */       this.name = name;
/*  59 */       this.config = config;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.SecurityConfig
 * JD-Core Version:    0.6.0
 */