/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.message.MessageInfo;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.SubjectSecurityManager;
/*     */ import org.jboss.security.auth.callback.SecurityAssociationHandler;
/*     */ import org.jboss.security.plugins.auth.JaasSecurityManagerBase;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.CachePolicy;
/*     */ 
/*     */ public class JaasSecurityManager extends ServiceMBeanSupport
/*     */   implements SubjectSecurityManager, RealmMapping
/*     */ {
/*  59 */   private JaasSecurityManagerBase delegate = null;
/*     */ 
/*     */   public JaasSecurityManager()
/*     */   {
/*  66 */     this("other", new SecurityAssociationHandler());
/*     */   }
/*     */ 
/*     */   public JaasSecurityManager(String securityDomain, CallbackHandler handler)
/*     */   {
/*  77 */     this.delegate = new JaasSecurityManagerBase(securityDomain, handler);
/*     */   }
/*     */ 
/*     */   public void setCachePolicy(CachePolicy domainCache)
/*     */   {
/*  87 */     this.delegate.setCachePolicy(domainCache);
/*     */   }
/*     */ 
/*     */   public void setDeepCopySubjectOption(Boolean flag)
/*     */   {
/*  98 */     this.delegate.setDeepCopySubjectOption(flag);
/*     */   }
/*     */ 
/*     */   public void flushCache()
/*     */   {
/* 106 */     this.delegate.flushCache();
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 114 */     return this.delegate.getSecurityDomain();
/*     */   }
/*     */ 
/*     */   public Subject getActiveSubject()
/*     */   {
/* 124 */     return this.delegate.getActiveSubject();
/*     */   }
/*     */ 
/*     */   public boolean isValid(Principal principal, Object credential)
/*     */   {
/* 135 */     return this.delegate.isValid(principal, credential, null);
/*     */   }
/*     */ 
/*     */   public boolean isValid(Principal principal, Object credential, Subject activeSubject)
/*     */   {
/* 153 */     return this.delegate.isValid(principal, credential, activeSubject);
/*     */   }
/*     */ 
/*     */   public boolean isValid(MessageInfo requestMessage, Subject clientSubject, String layer)
/*     */   {
/* 158 */     return this.delegate.isValid(requestMessage, clientSubject, layer);
/*     */   }
/*     */ 
/*     */   public Principal getPrincipal(Principal principal)
/*     */   {
/* 171 */     return this.delegate.getPrincipal(principal);
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(Principal principal, Set<Principal> rolePrincipals)
/*     */   {
/* 193 */     return this.delegate.doesUserHaveRole(principal, rolePrincipals);
/*     */   }
/*     */ 
/*     */   public Set<Principal> getUserRoles(Principal principal)
/*     */   {
/* 206 */     return this.delegate.getUserRoles(principal);
/*     */   }
/*     */ 
/*     */   public Principal getTargetPrincipal(Principal anotherDomainPrincipal, Map<String, Object> contextMap)
/*     */   {
/* 214 */     return this.delegate.getTargetPrincipal(anotherDomainPrincipal, contextMap);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.JaasSecurityManager
 * JD-Core Version:    0.6.0
 */