/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.ISecurityManagement;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.SubjectInfo;
/*     */ import org.jboss.security.audit.AuditManager;
/*     */ import org.jboss.security.auth.callback.SecurityAssociationHandler;
/*     */ import org.jboss.security.identitytrust.IdentityTrustManager;
/*     */ import org.jboss.security.mapping.MappingManager;
/*     */ 
/*     */ public class JBossSecurityContext
/*     */   implements SecurityContext
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  43 */   protected static final Logger log = Logger.getLogger(JBossSecurityContext.class);
/*  44 */   protected boolean trace = log.isTraceEnabled();
/*     */ 
/*  46 */   protected Map<String, Object> contextData = new HashMap();
/*     */ 
/*  48 */   protected String securityDomain = "other";
/*     */ 
/*  50 */   protected SubjectInfo subjectInfo = null;
/*     */ 
/*  52 */   protected RunAs incomingRunAs = null;
/*  53 */   protected RunAs outgoingRunAs = null;
/*     */   protected ISecurityManagement iSecurityManagement;
/*  57 */   protected CallbackHandler callbackHandler = new SecurityAssociationHandler();
/*     */ 
/*     */   public JBossSecurityContext(String securityDomain)
/*     */   {
/*  61 */     this.securityDomain = securityDomain;
/*  62 */     this.iSecurityManagement = new DefaultSecurityManagement(this.callbackHandler);
/*     */ 
/*  64 */     getUtil().createSubjectInfo(null, null, null);
/*     */   }
/*     */ 
/*     */   public ISecurityManagement getSecurityManagement()
/*     */   {
/*  73 */     return this.iSecurityManagement;
/*     */   }
/*     */ 
/*     */   public void setSecurityManagement(ISecurityManagement ism)
/*     */   {
/*  81 */     if (ism == null)
/*  82 */       throw new IllegalArgumentException("ism is null");
/*  83 */     this.iSecurityManagement = ism;
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getData()
/*     */   {
/*  91 */     return this.contextData;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/*  96 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public SubjectInfo getSubjectInfo()
/*     */   {
/* 105 */     return this.subjectInfo;
/*     */   }
/*     */ 
/*     */   public RunAs getIncomingRunAs()
/*     */   {
/* 113 */     return this.incomingRunAs;
/*     */   }
/*     */ 
/*     */   public void setIncomingRunAs(RunAs runAs)
/*     */   {
/* 121 */     this.incomingRunAs = runAs;
/*     */   }
/*     */ 
/*     */   public RunAs getOutgoingRunAs()
/*     */   {
/* 129 */     return this.outgoingRunAs;
/*     */   }
/*     */ 
/*     */   public void setOutgoingRunAs(RunAs runAs)
/*     */   {
/* 137 */     this.outgoingRunAs = runAs;
/*     */   }
/*     */ 
/*     */   public SecurityContextUtil getUtil()
/*     */   {
/* 145 */     SecurityContextUtil util = null;
/*     */     try
/*     */     {
/* 148 */       util = SecurityContextFactory.createUtil(this);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 152 */       throw new IllegalStateException(e);
/*     */     }
/* 154 */     return util;
/*     */   }
/*     */ 
/*     */   public AuditManager getAuditManager()
/*     */   {
/* 161 */     return this.iSecurityManagement.getAuditManager(this.securityDomain);
/*     */   }
/*     */ 
/*     */   public AuthenticationManager getAuthenticationManager()
/*     */   {
/* 167 */     return this.iSecurityManagement.getAuthenticationManager(this.securityDomain);
/*     */   }
/*     */ 
/*     */   public AuthorizationManager getAuthorizationManager()
/*     */   {
/* 173 */     return this.iSecurityManagement.getAuthorizationManager(this.securityDomain);
/*     */   }
/*     */ 
/*     */   public IdentityTrustManager getIdentityTrustManager()
/*     */   {
/* 179 */     return this.iSecurityManagement.getIdentityTrustManager(this.securityDomain);
/*     */   }
/*     */ 
/*     */   public MappingManager getMappingManager()
/*     */   {
/* 185 */     return this.iSecurityManagement.getMappingManager(this.securityDomain);
/*     */   }
/*     */ 
/*     */   public void setSubjectInfo(SubjectInfo si)
/*     */   {
/* 193 */     this.subjectInfo = si;
/*     */   }
/*     */ 
/*     */   public void setRoles(Group roles, boolean replace)
/*     */   {
/* 198 */     Group mergedRoles = roles;
/* 199 */     if (!replace)
/*     */     {
/* 201 */       mergedRoles = mergeGroups((Group)this.contextData.get("Roles"), roles);
/*     */     }
/* 203 */     this.contextData.put("Roles", mergedRoles);
/*     */   }
/*     */ 
/*     */   private Group mergeGroups(Group a, Group b)
/*     */   {
/* 208 */     Group newGroup = b;
/* 209 */     if (a != null)
/*     */     {
/* 211 */       Enumeration en = a.members();
/* 212 */       while (en.hasMoreElements())
/*     */       {
/* 214 */         newGroup.addMember((Principal)en.nextElement());
/*     */       }
/*     */     }
/* 217 */     return newGroup;
/*     */   }
/*     */ 
/*     */   public void setCallbackHandler(CallbackHandler callbackHandler)
/*     */   {
/* 227 */     this.callbackHandler = callbackHandler;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 233 */     JBossSecurityContext jsc = (JBossSecurityContext)super.clone();
/* 234 */     if (jsc != null)
/* 235 */       jsc.contextData = ((Map)((HashMap)this.contextData).clone());
/* 236 */     return super.clone();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.JBossSecurityContext
 * JD-Core Version:    0.6.0
 */