/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.io.RandomAccessFile;
/*     */ import javax.crypto.Cipher;
/*     */ import javax.crypto.SecretKey;
/*     */ import javax.crypto.SecretKeyFactory;
/*     */ import javax.crypto.spec.PBEKeySpec;
/*     */ import javax.crypto.spec.PBEParameterSpec;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class FilePassword
/*     */ {
/*     */   private File passwordFile;
/*     */ 
/*     */   public FilePassword(String file)
/*     */   {
/*  62 */     this.passwordFile = new File(file);
/*     */   }
/*     */ 
/*     */   public char[] toCharArray()
/*     */     throws IOException
/*     */   {
/*  68 */     RandomAccessFile raf = new RandomAccessFile(this.passwordFile, "rws");
/*     */     try
/*     */     {
/*  71 */       char[] password = decode(raf);
/*  72 */       return password;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  76 */       Logger log = Logger.getLogger(FilePassword.class);
/*  77 */       log.error("Failed to decode password file: " + this.passwordFile, e);
/*  78 */     }throw new IOException(e.getMessage());
/*     */   }
/*     */ 
/*     */   static char[] decode(RandomAccessFile passwordFile)
/*     */     throws Exception
/*     */   {
/*  85 */     byte[] salt = new byte[8];
/*  86 */     passwordFile.readFully(salt);
/*  87 */     int count = passwordFile.readInt();
/*  88 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/*     */     int b;
/*  90 */     while ((b = passwordFile.read()) >= 0)
/*  91 */       baos.write(b);
/*  92 */     passwordFile.close();
/*  93 */     byte[] secret = baos.toByteArray();
/*     */ 
/*  95 */     PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
/*  96 */     PBEKeySpec keySpec = new PBEKeySpec("78aac249a60a13d5e882927928043ebb".toCharArray());
/*  97 */     SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
/*  98 */     SecretKey cipherKey = factory.generateSecret(keySpec);
/*  99 */     Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
/* 100 */     cipher.init(2, cipherKey, cipherSpec);
/* 101 */     byte[] decode = cipher.doFinal(secret);
/* 102 */     return new String(decode, "UTF-8").toCharArray();
/*     */   }
/*     */ 
/*     */   static void encode(RandomAccessFile passwordFile, byte[] salt, int count, byte[] secret)
/*     */     throws Exception
/*     */   {
/* 108 */     PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
/* 109 */     PBEKeySpec keySpec = new PBEKeySpec("78aac249a60a13d5e882927928043ebb".toCharArray());
/* 110 */     SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
/* 111 */     SecretKey cipherKey = factory.generateSecret(keySpec);
/* 112 */     Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
/* 113 */     cipher.init(1, cipherKey, cipherSpec);
/* 114 */     byte[] encode = cipher.doFinal(secret);
/* 115 */     passwordFile.write(salt);
/* 116 */     passwordFile.writeInt(count);
/* 117 */     passwordFile.write(encode);
/* 118 */     passwordFile.close();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/* 130 */     if (args.length != 4)
/*     */     {
/* 132 */       System.err.println("Write a password in opaque form to a file for use with the FilePassword accessorUsage: FilePassword salt count password password-file  salt  : an 8 char sequence for PBEKeySpec  count : iteration count for PBEKeySpec  password : the clear text password to write  password-file : the path to the file to write the password to");
/*     */     }
/*     */ 
/* 141 */     byte[] salt = args[0].substring(0, 8).getBytes();
/* 142 */     int count = Integer.parseInt(args[1]);
/* 143 */     byte[] passwordBytes = args[2].getBytes("UTF-8");
/* 144 */     RandomAccessFile passwordFile = new RandomAccessFile(args[3], "rws");
/* 145 */     encode(passwordFile, salt, count, passwordBytes);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.FilePassword
 * JD-Core Version:    0.6.0
 */