/*    */ package org.jboss.security.plugins;
/*    */ 
/*    */ import javax.security.auth.callback.CallbackHandler;
/*    */ import org.jboss.security.AuthenticationManager;
/*    */ import org.jboss.security.AuthorizationManager;
/*    */ import org.jboss.security.ISecurityManagement;
/*    */ import org.jboss.security.audit.AuditManager;
/*    */ import org.jboss.security.identitytrust.IdentityTrustManager;
/*    */ import org.jboss.security.mapping.MappingManager;
/*    */ import org.jboss.security.plugins.audit.JBossAuditManager;
/*    */ import org.jboss.security.plugins.identitytrust.JBossIdentityTrustManager;
/*    */ import org.jboss.security.plugins.mapping.JBossMappingManager;
/*    */ 
/*    */ public class DefaultSecurityManagement
/*    */   implements ISecurityManagement
/*    */ {
/* 45 */   private CallbackHandler handler = null;
/*    */ 
/*    */   public DefaultSecurityManagement(CallbackHandler cbh)
/*    */   {
/* 49 */     this.handler = cbh;
/*    */   }
/*    */ 
/*    */   public AuditManager getAuditManager(String securityDomain)
/*    */   {
/* 57 */     return new JBossAuditManager(securityDomain);
/*    */   }
/*    */ 
/*    */   public AuthenticationManager getAuthenticationManager(String securityDomain)
/*    */   {
/* 65 */     return new JBossAuthenticationManager(securityDomain, this.handler);
/*    */   }
/*    */ 
/*    */   public AuthorizationManager getAuthorizationManager(String securityDomain)
/*    */   {
/* 73 */     return new JBossAuthorizationManager(securityDomain);
/*    */   }
/*    */ 
/*    */   public IdentityTrustManager getIdentityTrustManager(String securityDomain)
/*    */   {
/* 81 */     return new JBossIdentityTrustManager(securityDomain);
/*    */   }
/*    */ 
/*    */   public MappingManager getMappingManager(String securityDomain)
/*    */   {
/* 89 */     return new JBossMappingManager(securityDomain);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.DefaultSecurityManagement
 * JD-Core Version:    0.6.0
 */